/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.access;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.BasePublicFormAction;
import nl.strohalm.cyclos.controls.access.LoginForm;
import nl.strohalm.cyclos.entities.access.MemberUser;
import nl.strohalm.cyclos.entities.access.User;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.access.exceptions.AlreadyConnectedException;
import nl.strohalm.cyclos.services.access.exceptions.BlockedCredentialsException;
import nl.strohalm.cyclos.services.access.exceptions.InactiveMemberException;
import nl.strohalm.cyclos.services.access.exceptions.LoginException;
import nl.strohalm.cyclos.utils.LoginHelper;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class ExternalLoginAction
extends BasePublicFormAction {
    private LoginHelper loginHelper;

    @Override
    public void prepareForm(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, String> statusMessages = new HashMap<String, String>();
        for (Status status : Status.values()) {
            String key = status.getKey();
            if (key == null) continue;
            String argument = status.getArgument();
            if (argument != null) {
                argument = this.messageHelper.message(argument, new Object[0]);
            }
            statusMessages.put(status.name(), this.messageHelper.message(key, argument));
        }
        request.setAttribute("statusMessages", statusMessages);
        String afterLogout = request.getParameter("afterLogout");
        afterLogout = StringUtils.trimToEmpty((String)afterLogout);
        try {
            LocalSettings settings = this.settingsService.getLocalSettings();
            afterLogout = URLEncoder.encode(StringUtils.trimToEmpty((String)afterLogout), settings.getCharset());
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        Cookie cookie = new Cookie("afterLogout", afterLogout);
        cookie.setPath(request.getContextPath());
        response.addCookie(cookie);
    }

    @Inject
    public final void setLoginHelper(LoginHelper loginHelper) {
        this.loginHelper = loginHelper;
    }

    @Override
    protected ActionForward handleDisplay(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        User loggedUser = LoginHelper.getLoggedUser(request);
        if (loggedUser != null) {
            HttpSession session = request.getSession();
            return new ActionForward(session.getAttribute("pathPrefix") + "/home", true);
        }
        return super.handleDisplay(mapping, actionForm, request, response);
    }

    @Override
    protected ActionForward handleSubmit(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        User user;
        Status status = this.doLogin(actionForm, request, response);
        if (status == Status.SUCCESS && (user = LoginHelper.getLoggedUser(request)) instanceof MemberUser && this.elementService.shallAcceptAgreement(((MemberUser)user).getMember())) {
            request.getSession().setAttribute("shallAcceptRegistrationAgreement", (Object)true);
        }
        this.responseHelper.setTextNoCache(response);
        response.getWriter().print(status.name());
        return null;
    }

    private Status doLogin(ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        LoginForm form = (LoginForm)actionForm;
        HttpSession session = request.getSession();
        String member = StringUtils.trimToNull((String)form.getMember());
        String principal = StringUtils.trimToNull((String)form.getPrincipal());
        String password = StringUtils.trimToNull((String)form.getPassword());
        if (principal == null) {
            return Status.MISSING_USERNAME;
        }
        if (password == null) {
            return Status.MISSING_PASSWORD;
        }
        try {
            this.loginHelper.login(User.class, form.getPrincipalType(), member, principal, password, "web", request, response);
            return Status.SUCCESS;
        }
        catch (BlockedCredentialsException e) {
            return Status.BLOCKED;
        }
        catch (InactiveMemberException e) {
            return Status.INACTIVE;
        }
        catch (AlreadyConnectedException e) {
            return Status.ALREADY_CONNECTED;
        }
        catch (PermissionDeniedException e) {
            session.invalidate();
            return Status.PERMISSION_DENIED;
        }
        catch (LoginException e) {
            return Status.INVALID;
        }
        catch (Exception e) {
            this.actionHelper.generateLog(request, this.getServlet().getServletContext(), e);
            return Status.UNKNOWN_ERROR;
        }
    }

    public static enum Status {
        SUCCESS(null),
        MISSING_USERNAME("errors.required", "login.username"),
        ALREADY_CONNECTED("login.error.alreadyConnected"),
        MISSING_PASSWORD("errors.required", "login.password"),
        INVALID("login.error"),
        BLOCKED("login.error.blocked"),
        INACTIVE("login.error.inactive"),
        PERMISSION_DENIED("error.accessDenied"),
        UNKNOWN_ERROR("error.general");

        private final String key;
        private final String argument;

        private Status(String key) {
            this(key, null);
        }

        private Status(String key, String argument) {
            this.key = key;
            this.argument = argument;
        }

        public String getArgument() {
            return this.argument;
        }

        public String getKey() {
            return this.key;
        }
    }
}

