/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.access;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.access.AdminAdminPermission;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseQueryAction;
import nl.strohalm.cyclos.controls.access.ListConnectedUsersForm;
import nl.strohalm.cyclos.entities.access.Session;
import nl.strohalm.cyclos.entities.access.SessionQuery;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.utils.RequestHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.DataBinderHelper;
import nl.strohalm.cyclos.utils.binding.SimpleCollectionBinder;
import nl.strohalm.cyclos.utils.query.QueryParameters;

public class ListConnectedUsersAction
extends BaseQueryAction {
    private DataBinder<SessionQuery> dataBinderAsAdmin;
    private DataBinder<SessionQuery> dataBinderAdMember;

    public DataBinder<SessionQuery> getDataBinderAsAdmin() {
        if (this.dataBinderAsAdmin == null) {
            BeanBinder<SessionQuery> binder = BeanBinder.instance(SessionQuery.class);
            binder.registerBinder("natures", SimpleCollectionBinder.instance(Group.Nature.class, "natures"));
            binder.registerBinder("groups", SimpleCollectionBinder.instance(Group.class, "groups"));
            binder.registerBinder("pageParameters", DataBinderHelper.pageBinder());
            this.dataBinderAsAdmin = binder;
        }
        return this.dataBinderAsAdmin;
    }

    public DataBinder<SessionQuery> getDataBinderAsMember() {
        if (this.dataBinderAdMember == null) {
            BeanBinder<SessionQuery> binder = BeanBinder.instance(SessionQuery.class);
            binder.registerBinder("pageParameters", DataBinderHelper.pageBinder());
            this.dataBinderAdMember = binder;
        }
        return this.dataBinderAdMember;
    }

    @Override
    protected void executeQuery(ActionContext context, QueryParameters queryParameters) {
        SessionQuery query = (SessionQuery)queryParameters;
        List<Session> sessions = this.accessService.searchSessions(query);
        context.getRequest().setAttribute("sessions", sessions);
    }

    @Override
    protected QueryParameters prepareForm(ActionContext context) {
        ListConnectedUsersForm form = (ListConnectedUsersForm)((Object)context.getForm());
        HttpServletRequest request = context.getRequest();
        DataBinder<SessionQuery> dataBinder = context.isAdmin() ? this.getDataBinderAsAdmin() : this.getDataBinderAsMember();
        SessionQuery query = dataBinder.readFromString(form.getQuery());
        if (context.isAdmin()) {
            RequestHelper.storeEnum(request, Group.Nature.class, "groupNatures");
        } else {
            query.setNatures(null);
            query.setGroups(null);
            query.setMember(context.getMember());
        }
        request.setAttribute("canDisconnectAdmin", (Object)this.permissionService.hasPermission(AdminAdminPermission.ACCESS_DISCONNECT));
        request.setAttribute("canDisconnectMember", (Object)this.permissionService.hasPermission(AdminMemberPermission.ACCESS_DISCONNECT));
        return query;
    }

    @Override
    protected boolean willExecuteQuery(ActionContext context, QueryParameters queryParameters) throws Exception {
        return true;
    }
}

