/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.access;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.BasePublicFormAction;
import nl.strohalm.cyclos.controls.access.LoginForm;
import nl.strohalm.cyclos.entities.access.Channel;
import nl.strohalm.cyclos.entities.access.MemberUser;
import nl.strohalm.cyclos.entities.access.PrincipalType;
import nl.strohalm.cyclos.entities.access.User;
import nl.strohalm.cyclos.entities.settings.AccessSettings;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.exceptions.AccessDeniedException;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.access.AccessService;
import nl.strohalm.cyclos.services.access.ChannelService;
import nl.strohalm.cyclos.services.access.exceptions.AlreadyConnectedException;
import nl.strohalm.cyclos.services.access.exceptions.BlockedCredentialsException;
import nl.strohalm.cyclos.services.access.exceptions.InactiveMemberException;
import nl.strohalm.cyclos.services.access.exceptions.LoginException;
import nl.strohalm.cyclos.services.access.exceptions.SystemOfflineException;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.LoginHelper;
import nl.strohalm.cyclos.utils.StringHelper;
import nl.strohalm.cyclos.utils.validation.RequiredError;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class LoginAction
extends BasePublicFormAction {
    protected AccessService accessService;
    protected ChannelService channelService;
    protected LoginHelper loginHelper;

    public ChannelService getChannelService() {
        return this.channelService;
    }

    @Inject
    public void setAccessService(AccessService accessService) {
        this.accessService = accessService;
    }

    @Inject
    public void setChannelService(ChannelService channelService) {
        this.channelService = channelService;
    }

    @Inject
    public final void setLoginHelper(LoginHelper loginHelper) {
        this.loginHelper = loginHelper;
    }

    protected ActionForward alreadyLoggedForward(ActionMapping mapping, HttpServletRequest request, HttpServletResponse response, LoginForm form, User user) {
        HttpSession session = request.getSession();
        return new ActionForward(session.getAttribute("pathPrefix") + "/home", true);
    }

    protected ActionForward doLogin(ActionMapping mapping, HttpServletRequest request, HttpServletResponse response, LoginForm form) {
        String member = StringUtils.trimToNull((String)form.getMember());
        String principal = StringUtils.trimToNull((String)form.getPrincipal());
        String password = form.getPassword();
        String errorReturnTo = this.resolveErrorReturnTo(mapping, request, response, form);
        HttpSession session = request.getSession();
        if (errorReturnTo == null) {
            session.removeAttribute("errorReturnTo");
            session.setAttribute("forceBack", (Object)true);
        } else {
            session.setAttribute("errorReturnTo", (Object)errorReturnTo);
        }
        try {
            Class<? extends User> requiredUserType = this.requiredUserType(mapping, request, response, form);
            User user = this.loginHelper.login(requiredUserType, form.getPrincipalType(), member, principal, password, "web", request, response);
            return this.loginForward(mapping, request, response, form, user);
        }
        catch (BlockedCredentialsException e) {
            return ActionHelper.sendError(mapping, request, response, "login.error.blocked", new Object[0]);
        }
        catch (InactiveMemberException e) {
            return ActionHelper.sendError(mapping, request, response, "login.error.inactive", new Object[0]);
        }
        catch (AlreadyConnectedException e) {
            return ActionHelper.sendError(mapping, request, response, "login.error.alreadyConnected", new Object[0]);
        }
        catch (AccessDeniedException e) {
            return ActionHelper.sendError(mapping, request, response, "error.accessDenied", new Object[0]);
        }
        catch (PermissionDeniedException e) {
            return ActionHelper.sendError(mapping, request, response, "error.accessDenied", new Object[0]);
        }
        catch (SystemOfflineException e) {
            return ActionHelper.sendError(mapping, request, response, "error.systemOffline", new Object[0]);
        }
        catch (LoginException e) {
            return ActionHelper.sendError(mapping, request, response, "login.error", new Object[0]);
        }
    }

    @Override
    protected ActionForward handleDisplay(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        LoginForm form = (LoginForm)actionForm;
        HttpSession session = request.getSession();
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        AccessSettings accessSettings = this.settingsService.getAccessSettings();
        session.removeAttribute("errorReturnTo");
        if (session.getAttribute("loggedOut") != null) {
            request.setAttribute("loggedOut", (Object)true);
            session.removeAttribute("loggedOut");
        }
        boolean allowOperatorLogin = accessSettings.isAllowOperatorLogin();
        boolean isOperator = Boolean.parseBoolean(request.getParameter("operator"));
        ArrayList<Map<String, String>> accessLinks = new ArrayList<Map<String, String>>();
        PrincipalType selectedPrincipalType = this.channelService.resolvePrincipalType("web", form.getPrincipalType());
        if (isOperator) {
            accessLinks.add(this.createLink(request, this.messageHelper.message("login.action.loginAsMember", new Object[0]), null, null));
            selectedPrincipalType = Channel.DEFAULT_PRINCIPAL_TYPE;
        } else {
            Channel web = this.channelService.loadByInternalName("web");
            Set<PrincipalType> allPrincipalTypes = web.getPrincipalTypes();
            for (PrincipalType principalType : allPrincipalTypes) {
                if (principalType.getPrincipal() == Channel.Principal.EMAIL && !localSettings.isEmailUnique()) {
                    if (!selectedPrincipalType.equals(principalType)) continue;
                    selectedPrincipalType = Channel.DEFAULT_PRINCIPAL_TYPE;
                    continue;
                }
                if (principalType.equals(selectedPrincipalType)) continue;
                String label = this.messageHelper.message("login.accessUsing", this.resolvePrincipalLabel(principalType));
                accessLinks.add(this.createLink(request, label, "principalType", principalType.toString()));
            }
            if (allowOperatorLogin) {
                accessLinks.add(this.createLink(request, this.messageHelper.message("login.action.loginAsOperator", new Object[0]), "operator", "true"));
            }
        }
        request.setAttribute("selectedPrincipalType", (Object)selectedPrincipalType);
        request.setAttribute("selectedPrincipalLabel", (Object)this.resolvePrincipalLabel(selectedPrincipalType));
        request.setAttribute("accessLinks", accessLinks);
        request.setAttribute("singleAccessLink", accessLinks.size() == 1 ? (Map)accessLinks.get(0) : null);
        User user = LoginHelper.getLoggedUser(request);
        if (user != null) {
            return this.alreadyLoggedForward(mapping, request, response, form, user);
        }
        this.storeCookie(request, response, true);
        return mapping.getInputForward();
    }

    @Override
    protected ActionForward handleSubmit(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        return this.doLogin(mapping, request, response, (LoginForm)actionForm);
    }

    protected boolean isMemberRequired(HttpServletRequest request) {
        return "true".equals(request.getParameter("operatorLogin"));
    }

    protected ActionForward loginForward(ActionMapping mapping, HttpServletRequest request, HttpServletResponse response, LoginForm form, User user) {
        String returnTo = (String)request.getSession().getAttribute("returnTo");
        ActionForward forward = null;
        if (user instanceof MemberUser && this.elementService.shallAcceptAgreement(((MemberUser)user).getMember())) {
            request.getSession().setAttribute("shallAcceptRegistrationAgreement", (Object)true);
            forward = mapping.findForward("acceptRegistrationAgreement");
        } else if (this.accessService.hasPasswordExpired()) {
            request.getSession().setAttribute("expiredPassword", (Object)true);
            forward = this.actionHelper.getForwardFor(user.getElement().getNature(), "changeExpiredPassword", true);
        } else if (StringUtils.isNotEmpty((String)returnTo)) {
            HttpSession session = request.getSession();
            session.removeAttribute("returnTo");
            forward = new ActionForward(!returnTo.startsWith("/do") ? "/do" + returnTo : returnTo, true);
        } else {
            forward = this.actionHelper.getForwardFor(user.getElement().getNature(), "home", true);
        }
        return forward;
    }

    protected Class<? extends User> requiredUserType(ActionMapping mapping, HttpServletRequest request, HttpServletResponse response, LoginForm form) {
        return User.class;
    }

    protected String resolveErrorReturnTo(ActionMapping mapping, HttpServletRequest request, HttpServletResponse response, LoginForm form) {
        String member = StringUtils.trimToNull((String)form.getMember());
        if (StringUtils.isEmpty((String)member)) {
            return null;
        }
        return "/do/login?operator=true";
    }

    @Override
    protected void validateForm(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws ValidationException {
        LoginForm form = (LoginForm)actionForm;
        String member = null;
        boolean memberRequired = this.isMemberRequired(request);
        if (memberRequired) {
            member = StringUtils.trimToNull((String)form.getMember());
        }
        String principal = StringUtils.trimToNull((String)form.getPrincipal());
        String password = form.getPassword();
        ValidationException vex = new ValidationException();
        if (memberRequired && member == null) {
            vex.setPropertyKey("member", "login.memberUsername");
            vex.addPropertyError("member", new RequiredError(new Object[0]));
        }
        if (principal == null) {
            vex.setPropertyKey("username", "login.username");
            vex.addPropertyError("username", new RequiredError(new Object[0]));
        }
        if (StringUtils.isEmpty((String)password)) {
            vex.setPropertyKey("_password", "login.password");
            vex.addPropertyError("_password", new RequiredError(new Object[0]));
        }
        vex.throwIfHasErrors();
    }

    private Map<String, String> createLink(HttpServletRequest request, String label, String paramName, String paramValue) {
        HashMap<String, String> link = new HashMap<String, String>();
        link.put("label", label);
        link.put("paramName", paramName);
        link.put("paramValue", paramValue);
        return link;
    }

    private String resolvePrincipalLabel(PrincipalType principalType) {
        Channel.Principal principal = principalType.getPrincipal();
        if (principal == Channel.Principal.CUSTOM_FIELD) {
            return principalType.getCustomField().getName();
        }
        return this.messageHelper.message(principal.getKey(), new Object[0]);
    }

    private void storeCookie(HttpServletRequest request, HttpServletResponse response, boolean force) {
        String queryString = StringHelper.removeMarkupTags(request.getQueryString());
        if (force || StringUtils.isNotEmpty((String)queryString)) {
            Cookie queryStringCookie = new Cookie("loginQueryString", StringHelper.encodeUrl(queryString));
            queryStringCookie.setPath(request.getContextPath());
            response.addCookie(queryStringCookie);
        }
        if (force) {
            Cookie afterLogoutCookie = new Cookie("afterLogout", null);
            afterLogoutCookie.setPath(request.getContextPath());
            response.addCookie(afterLogoutCookie);
        }
    }
}

