/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.access;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.services.settings.SettingsService;
import nl.strohalm.cyclos.utils.RequestHelper;
import nl.strohalm.cyclos.utils.StringHelper;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class LogoutAction
extends Action {
    private SettingsService settingsService;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.getSession().invalidate();
        Cookie afterLogout = RequestHelper.getCookie((ServletRequest)request, "afterLogout");
        if (afterLogout != null && StringUtils.isNotEmpty((String)afterLogout.getValue())) {
            String url = afterLogout.getValue();
            afterLogout.setValue("");
            response.addCookie(afterLogout);
            try {
                LocalSettings settings = this.settingsService.getLocalSettings();
                url = URLDecoder.decode(url, settings.getCharset());
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
            response.sendRedirect(url);
            return null;
        }
        ActionForward forward = mapping.findForward("success");
        String queryString = RequestHelper.getCookieValue((ServletRequest)request, "loginQueryString");
        if (StringUtils.isNotEmpty((String)queryString)) {
            queryString = StringHelper.decodeUrl(queryString);
            if ((queryString = StringHelper.removeQueryStringVariable(queryString, "returnTo")).endsWith("&")) {
                queryString = queryString.substring(0, queryString.length() - 1);
            }
            String path = forward.getPath();
            if (StringUtils.isNotEmpty((String)queryString)) {
                path = path + "?" + queryString;
            }
            forward = new ActionForward(path, true);
        }
        return forward;
    }

    @Inject
    public void setSettingsService(SettingsService settingsService) {
        this.settingsService = settingsService;
    }
}

