/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.access;

import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.access.BrokerPermission;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseAction;
import nl.strohalm.cyclos.controls.access.ManagePasswordsForm;
import nl.strohalm.cyclos.entities.access.AdminUser;
import nl.strohalm.cyclos.entities.access.MemberUser;
import nl.strohalm.cyclos.entities.access.OperatorUser;
import nl.strohalm.cyclos.entities.access.User;
import nl.strohalm.cyclos.entities.groups.BasicGroupSettings;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.Operator;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.struts.action.ActionForward;

public class ManagePasswordsAction
extends BaseAction {
    @Override
    protected ActionForward executeAction(ActionContext context) throws Exception {
        boolean tpUsed;
        HttpServletRequest request = context.getRequest();
        ManagePasswordsForm form = (ManagePasswordsForm)((Object)context.getForm());
        long userId = form.getUserId();
        User user = null;
        try {
            if (userId > 0L) {
                user = this.elementService.loadUser(userId, RelationshipHelper.nested(User.Relationships.ELEMENT, Element.Relationships.GROUP));
            }
            if (user == null) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            throw new ValidationException();
        }
        Element element = user.getElement();
        if (element instanceof Operator) {
            element = this.elementService.load(element.getId(), RelationshipHelper.nested(Operator.Relationships.MEMBER, Element.Relationships.GROUP));
        }
        BasicGroupSettings groupSettings = element.getGroup().getBasicSettings();
        boolean sendPasswordByEmail = false;
        if (user instanceof MemberUser) {
            sendPasswordByEmail = ((MemberUser)user).getMember().getMemberGroup().getMemberSettings().isSendPasswordByEmail();
        }
        boolean canChangePassword = false;
        boolean canResetPassword = false;
        boolean canManageTransactionPassword = false;
        boolean bl = tpUsed = groupSettings.getTransactionPassword() != null && groupSettings.getTransactionPassword().isUsed();
        if (context.isAdmin()) {
            canChangePassword = this.permissionService.hasPermission(AdminMemberPermission.ACCESS_CHANGE_PASSWORD);
            canResetPassword = sendPasswordByEmail && this.permissionService.hasPermission(AdminMemberPermission.ACCESS_RESET_PASSWORD);
            canManageTransactionPassword = tpUsed && this.permissionService.hasPermission(AdminMemberPermission.ACCESS_TRANSACTION_PASSWORD);
        } else if (context.isMember()) {
            if (user instanceof OperatorUser) {
                canChangePassword = true;
                canManageTransactionPassword = groupSettings.getTransactionPassword() != null && groupSettings.getTransactionPassword().isUsed();
            } else {
                if (!(user instanceof MemberUser) || !context.isBrokerOf((Member)element)) {
                    throw new ValidationException();
                }
                canChangePassword = this.permissionService.hasPermission(BrokerPermission.MEMBER_ACCESS_CHANGE_PASSWORD);
                canResetPassword = sendPasswordByEmail && this.permissionService.hasPermission(BrokerPermission.MEMBER_ACCESS_RESET_PASSWORD);
                canManageTransactionPassword = tpUsed && this.permissionService.hasPermission(BrokerPermission.MEMBER_ACCESS_TRANSACTION_PASSWORD);
            }
        }
        request.setAttribute("ofAdmin", (Object)(user instanceof AdminUser));
        request.setAttribute("ofOperator", (Object)(user instanceof OperatorUser));
        request.setAttribute("user", (Object)user);
        request.setAttribute("canChangePassword", (Object)canChangePassword);
        request.setAttribute("canResetPassword", (Object)canResetPassword);
        request.setAttribute("canManageTransactionPassword", (Object)canManageTransactionPassword);
        return context.getInputForward();
    }
}

