/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.access.channels;

import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.access.channels.ChangePinForm;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.access.Channel;
import nl.strohalm.cyclos.entities.access.MemberUser;
import nl.strohalm.cyclos.services.access.ChangePinDTO;
import nl.strohalm.cyclos.services.access.exceptions.BlockedCredentialsException;
import nl.strohalm.cyclos.services.access.exceptions.CredentialsAlreadyUsedException;
import nl.strohalm.cyclos.services.access.exceptions.InvalidCredentialsException;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import org.apache.struts.action.ActionForward;

public class ChangePinAction
extends BaseFormAction {
    private DataBinder<ChangePinDTO> dataBinder;

    public DataBinder<ChangePinDTO> getDataBinder() {
        if (this.dataBinder == null) {
            BeanBinder<ChangePinDTO> binder = BeanBinder.instance(ChangePinDTO.class);
            binder.registerBinder("user", PropertyBinder.instance(MemberUser.class, "memberId"));
            binder.registerBinder("credentials", PropertyBinder.instance(String.class, "credentials"));
            binder.registerBinder("newPin", PropertyBinder.instance(String.class, "newPin"));
            binder.registerBinder("newPinConfirmation", PropertyBinder.instance(String.class, "newPinConfirmation"));
            this.dataBinder = binder;
        }
        return this.dataBinder;
    }

    @Override
    protected ActionForward handleSubmit(ActionContext context) throws Exception {
        HttpServletRequest request = context.getRequest();
        ChangePinDTO params = this.resolveDto(context);
        MemberUser user = params.getUser();
        try {
            user = this.accessService.changePin(params);
            ActionForward forward = ((Entity)context.getUser()).equals(user) ? context.getSuccessForward() : ActionHelper.redirectWithParam(request, context.getSuccessForward(), "memberId", user.getId());
            context.sendMessage("changePin.modified", new Object[0]);
            return forward;
        }
        catch (InvalidCredentialsException e) {
            String key = "changePin.error." + (e.getCredentialsType() == Channel.Credentials.TRANSACTION_PASSWORD ? "invalidTransactionPassword" : "invalidPassword");
            return context.sendError(key, new Object[0]);
        }
        catch (BlockedCredentialsException e) {
            if (e.getCredentialsType() == Channel.Credentials.TRANSACTION_PASSWORD) {
                context.getSession().setAttribute("returnTo", (Object)(context.getPathPrefix() + "/manageExternalAcccess"));
                return context.sendError("changePin.error.blockedTransactionPassword", new Object[0]);
            }
            request.getSession().invalidate();
            return context.sendError("changePin.error.userBlocked", new Object[0]);
        }
        catch (CredentialsAlreadyUsedException e) {
            return context.sendError("changePin.error.alreadyUsed", new Object[0]);
        }
    }

    @Override
    protected void validateForm(ActionContext context) {
        ChangePinDTO params = this.resolveDto(context);
        this.accessService.validateChangePin(params);
    }

    private ChangePinDTO resolveDto(ActionContext context) {
        ChangePinForm form = (ChangePinForm)((Object)context.getForm());
        ChangePinDTO params = this.getDataBinder().readFromString((Object)form);
        if (params.getUser() == null) {
            params.setUser((MemberUser)context.getUser());
        }
        return params;
    }
}

