/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.access.channels;

import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.access.BrokerPermission;
import nl.strohalm.cyclos.access.MemberPermission;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseAction;
import nl.strohalm.cyclos.controls.access.channels.ManageExternalAccessForm;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.access.Channel;
import nl.strohalm.cyclos.entities.access.User;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.services.access.ChannelService;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import org.apache.struts.action.ActionForward;

public class ManageExternalAccessAction
extends BaseAction {
    private ChannelService channelService;

    @Inject
    public void setChannelService(ChannelService channelService) {
        this.channelService = channelService;
    }

    @Override
    protected ActionForward executeAction(ActionContext context) throws Exception {
        boolean usesTransactionPassword;
        boolean pinBlocked;
        Member member;
        HttpServletRequest request = context.getRequest();
        ManageExternalAccessForm form = (ManageExternalAccessForm)((Object)context.getForm());
        boolean myAccess = false;
        boolean memberCanHavePin = false;
        long memberId = form.getMemberId();
        if (memberId > 0L) {
            member = (Member)this.elementService.load(memberId, Element.Relationships.USER, Member.Relationships.CHANNELS, RelationshipHelper.nested(Element.Relationships.GROUP, MemberGroup.Relationships.CHANNELS));
            if (((Entity)context.getElement()).equals(member)) {
                myAccess = true;
            }
        } else {
            member = (Member)this.elementService.load(((Entity)context.getElement()).getId(), Element.Relationships.USER, Member.Relationships.CHANNELS, RelationshipHelper.nested(Element.Relationships.GROUP, MemberGroup.Relationships.CHANNELS));
            myAccess = true;
        }
        memberCanHavePin = this.groupService.usesPin(member.getMemberGroup());
        MemberGroup memberGroup = member.getMemberGroup();
        if (memberCanHavePin && (pinBlocked = this.accessService.isPinBlocked(member.getMemberUser()))) {
            boolean canUnblockPin = this.permissionService.permission(member).admin(AdminMemberPermission.ACCESS_UNBLOCK_PIN).broker(BrokerPermission.MEMBER_ACCESS_UNBLOCK_PIN).member(MemberPermission.ACCESS_UNBLOCK_PIN).hasPermission();
            request.setAttribute("canUnblockPin", (Object)canUnblockPin);
        }
        if (myAccess && (usesTransactionPassword = memberGroup.getBasicSettings().getTransactionPassword().isUsed())) {
            request.setAttribute("usesTransactionPassword", (Object)usesTransactionPassword);
            User.TransactionPasswordStatus transactionPasswordStatus = ((User)this.elementService.reloadUser(((Entity)context.getUser()).getId(), new Relationship[0])).getTransactionPasswordStatus();
            if (transactionPasswordStatus == User.TransactionPasswordStatus.BLOCKED) {
                request.setAttribute("transactionPasswordBlocked", (Object)true);
            } else if (transactionPasswordStatus.isGenerationAllowed()) {
                request.setAttribute("transactionPasswordPending", (Object)true);
            }
        }
        boolean canChangePin = memberCanHavePin && this.permissionService.permission(member).admin(AdminMemberPermission.ACCESS_CHANGE_PIN).broker(BrokerPermission.MEMBER_ACCESS_CHANGE_PIN).member(new MemberPermission[0]).hasPermission();
        Channel webChannel = this.channelService.loadByInternalName("web");
        ArrayList<Channel> memberGroupChannels = new ArrayList<Channel>(memberGroup.getChannels());
        memberGroupChannels.remove(webChannel);
        Channel smsChannel = this.channelService.getSmsChannel();
        boolean memberCanHaveSmsChannel = false;
        if (smsChannel != null) {
            memberCanHaveSmsChannel = memberGroupChannels.remove(smsChannel);
        }
        request.setAttribute("member", (Object)member);
        request.setAttribute("myAccess", (Object)myAccess);
        request.setAttribute("channels", memberGroupChannels);
        request.setAttribute("memberCanHavePin", (Object)memberCanHavePin);
        request.setAttribute("canChangePin", (Object)canChangePin);
        boolean hasPermission = this.permissionService.permission(member).admin(AdminMemberPermission.PREFERENCES_MANAGE_NOTIFICATIONS).member(MemberPermission.PREFERENCES_MANAGE_NOTIFICATIONS).broker(BrokerPermission.PREFERENCES_MANAGE_NOTIFICATIONS).hasPermission();
        request.setAttribute("canManagePreferences", (Object)(memberCanHaveSmsChannel && hasPermission ? 1 : 0));
        boolean canChangeChannelAccess = this.accessService.canChangeChannelsAccess(member);
        request.setAttribute("canChangeChannelAccess", (Object)canChangeChannelAccess);
        return context.getInputForward();
    }
}

