/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.access.transactionpassword;

import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseAjaxAction;
import nl.strohalm.cyclos.controls.access.transactionpassword.IsUsedTransactionPasswordAjaxForm;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.services.transfertypes.TransferTypeService;
import nl.strohalm.cyclos.utils.JSONBuilder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;

public class IsUsedTransactionPasswordAjaxAction
extends BaseAjaxAction {
    private TransferTypeService transferTypeService;

    @Inject
    public void setTransferTypeService(TransferTypeService transferTypeService) {
        this.transferTypeService = transferTypeService;
    }

    @Override
    protected BaseAjaxAction.ContentType contentType() {
        return BaseAjaxAction.ContentType.JSON;
    }

    @Override
    protected void renderContent(ActionContext context) throws Exception {
        IsUsedTransactionPasswordAjaxForm form = (IsUsedTransactionPasswordAjaxForm)((Object)context.getForm());
        boolean isUsed = false;
        try {
            Long transferTypeId = this.getDataBinder().readFromString((Object)form);
            TransferType transferType = this.transferTypeService.load(transferTypeId, TransferType.Relationships.FROM);
            isUsed = context.isTransactionPasswordEnabled(transferType.getFrom());
        }
        catch (Exception e) {
            // empty catch block
        }
        JSONBuilder json = new JSONBuilder();
        json.set("isUsed", isUsed);
        this.responseHelper.writeJSON(context.getResponse(), json);
    }

    private DataBinder<Long> getDataBinder() {
        return PropertyBinder.instance(Long.class, "transferTypeId");
    }
}

