/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.access.transactionpassword;

import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.access.transactionpassword.ManageTransactionPasswordForm;
import nl.strohalm.cyclos.entities.access.OperatorUser;
import nl.strohalm.cyclos.entities.access.TransactionPassword;
import nl.strohalm.cyclos.entities.access.User;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Operator;
import nl.strohalm.cyclos.services.elements.ResetTransactionPasswordDTO;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.RequestHelper;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.struts.action.ActionForward;

public class ManageTransactionPasswordAction
extends BaseFormAction {
    @Override
    protected ActionForward handleDisplay(ActionContext context) throws Exception {
        HttpServletRequest request = context.getRequest();
        ManageTransactionPasswordForm form = (ManageTransactionPasswordForm)((Object)context.getForm());
        User user = this.retrieveUser(context);
        boolean canReset = false;
        boolean canBlock = false;
        switch (user.getTransactionPasswordStatus()) {
            case ACTIVE: {
                canReset = true;
                canBlock = true;
                break;
            }
            case BLOCKED: {
                canReset = true;
                break;
            }
            case PENDING: {
                canBlock = true;
                break;
            }
            case NEVER_CREATED: {
                if (user.getElement().getGroup().getBasicSettings().getTransactionPassword() != TransactionPassword.MANUAL) break;
                canReset = true;
            }
        }
        request.setAttribute("groupStatus", (Object)user.getElement().getGroup().getBasicSettings().getTransactionPassword());
        request.setAttribute("user", (Object)user);
        request.setAttribute("canReset", (Object)canReset);
        request.setAttribute("canBlock", (Object)canBlock);
        RequestHelper.storeEnum(request, TransactionPassword.class, "globalTransactionPasswordStatus");
        RequestHelper.storeEnum(request, User.TransactionPasswordStatus.class, "userTransactionPasswordStatus");
        if (form.isEmbed()) {
            return new ActionForward("/pages/access/transactionPassword/manageTransactionPassword.jsp");
        }
        return context.getInputForward();
    }

    @Override
    protected ActionForward handleSubmit(ActionContext context) throws Exception {
        ManageTransactionPasswordForm form = (ManageTransactionPasswordForm)((Object)context.getForm());
        User user = this.retrieveUser(context);
        boolean block = form.isBlock();
        ResetTransactionPasswordDTO dto = new ResetTransactionPasswordDTO();
        dto.setUser(user);
        dto.setAllowGeneration(!block);
        user = this.accessService.resetTransactionPassword(dto);
        context.sendMessage(block ? "transactionPassword.blocked" : "transactionPassword.reset", new Object[0]);
        return ActionHelper.redirectWithParam(context.getRequest(), context.getSuccessForward(), "userId", user.getId());
    }

    private User retrieveUser(ActionContext context) {
        Object user;
        HttpServletRequest request = context.getRequest();
        if (request.getAttribute("element") != null) {
            return ((Element)request.getAttribute("element")).getUser();
        }
        ManageTransactionPasswordForm form = (ManageTransactionPasswordForm)((Object)context.getForm());
        long userId = form.getUserId();
        try {
            user = this.elementService.loadUser(userId, RelationshipHelper.nested(User.Relationships.ELEMENT, Element.Relationships.GROUP));
            if (user instanceof OperatorUser) {
                Element element = ((User)user).getElement();
                element = this.elementService.load(element.getId(), RelationshipHelper.nested(Operator.Relationships.MEMBER, Element.Relationships.GROUP));
            }
        }
        catch (Exception e) {
            throw new ValidationException();
        }
        return user;
    }
}

