/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.accounts.accountfees;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseQueryAction;
import nl.strohalm.cyclos.controls.accounts.accountfees.AccountFeeLogDetailsForm;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.fees.account.AccountFee;
import nl.strohalm.cyclos.entities.accounts.fees.account.AccountFeeLog;
import nl.strohalm.cyclos.entities.accounts.fees.account.AccountFeeLogDetailsDTO;
import nl.strohalm.cyclos.entities.accounts.fees.account.MemberAccountFeeLog;
import nl.strohalm.cyclos.entities.accounts.fees.account.MemberAccountFeeLogQuery;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.services.accountfees.AccountFeeService;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.DataBinderHelper;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.binding.SimpleCollectionBinder;
import nl.strohalm.cyclos.utils.query.QueryParameters;

public class AccountFeeLogDetailsAction
extends BaseQueryAction {
    private AccountFeeService accountFeeService;
    private DataBinder<MemberAccountFeeLogQuery> dataBinder;

    @Inject
    public void setAccountFeeService(AccountFeeService accountFeeService) {
        this.accountFeeService = accountFeeService;
    }

    @Override
    protected void executeQuery(ActionContext context, QueryParameters queryParameters) {
        HttpServletRequest request = context.getRequest();
        MemberAccountFeeLogQuery query = (MemberAccountFeeLogQuery)queryParameters;
        List<MemberAccountFeeLog> members = this.accountFeeService.searchMembers(query);
        request.setAttribute("members", members);
    }

    @Override
    protected QueryParameters prepareForm(ActionContext context) {
        HttpServletRequest request = context.getRequest();
        AccountFeeLogDetailsForm form = (AccountFeeLogDetailsForm)((Object)context.getForm());
        Long accountFeeLogId = form.getAccountFeeLogId();
        AccountFeeLogDetailsDTO details = this.accountFeeService.getLogDetails(accountFeeLogId);
        AccountFeeLog log = details.getAccountFeeLog();
        AccountFee fee = log.getAccountFee();
        boolean invoiceAlways = fee.getInvoiceMode() == AccountFee.InvoiceMode.ALWAYS;
        boolean invoiceNever = fee.getInvoiceMode() == AccountFee.InvoiceMode.NEVER;
        MemberAccountFeeLogQuery query = this.getDataBinder().readFromString(form.getQuery());
        query.setAccountFeeLog(log);
        if (query.getStatus() == null) {
            query.setStatus(log.getFailedMembers() == 0 ? MemberAccountFeeLogQuery.Status.PROCESSED : MemberAccountFeeLogQuery.Status.ERROR);
            form.setQuery("status", query.getStatus().name());
        }
        if (query.getMember() != null) {
            query.setMember((Member)this.elementService.load(query.getMember().getId(), new Relationship[0]));
        }
        EnumSet<MemberAccountFeeLogQuery.Status> statuses = EnumSet.allOf(MemberAccountFeeLogQuery.Status.class);
        if (invoiceAlways) {
            statuses.remove((Object)MemberAccountFeeLogQuery.Status.TRANSFER);
        } else if (invoiceNever) {
            statuses.remove((Object)MemberAccountFeeLogQuery.Status.INVOICE);
            statuses.remove((Object)MemberAccountFeeLogQuery.Status.ACCEPTED_INVOICE);
            statuses.remove((Object)MemberAccountFeeLogQuery.Status.OPEN_INVOICE);
        }
        ArrayList<MemberGroup> groups = new ArrayList<MemberGroup>(this.permissionService.getManagedMemberGroups());
        Collections.sort(groups);
        boolean isRunning = log.getFinishDate() == null || log.isRechargingFailed();
        request.setAttribute("details", (Object)details);
        request.setAttribute("log", (Object)log);
        request.setAttribute("fee", (Object)fee);
        request.setAttribute("currencyPattern", (Object)fee.getAccountType().getCurrency().getPattern());
        request.setAttribute("invoiceAlways", (Object)invoiceAlways);
        request.setAttribute("invoiceNever", (Object)invoiceNever);
        request.setAttribute("statuses", statuses);
        request.setAttribute("groups", groups);
        request.setAttribute("isRunning", (Object)isRunning);
        return query;
    }

    @Override
    protected boolean willExecuteQuery(ActionContext context, QueryParameters queryParameters) throws Exception {
        return true;
    }

    private DataBinder<MemberAccountFeeLogQuery> getDataBinder() {
        if (this.dataBinder == null) {
            BeanBinder<MemberAccountFeeLogQuery> binder = BeanBinder.instance(MemberAccountFeeLogQuery.class);
            binder.registerBinder("accountFeeLog", PropertyBinder.instance(AccountFeeLog.class, "accountFeeLog"));
            binder.registerBinder("status", PropertyBinder.instance(MemberAccountFeeLogQuery.Status.class, "status"));
            binder.registerBinder("groups", SimpleCollectionBinder.instance(MemberGroup.class, "groups"));
            binder.registerBinder("member", PropertyBinder.instance(Member.class, "member"));
            binder.registerBinder("pageParameters", DataBinderHelper.pageBinder());
            this.dataBinder = binder;
        }
        return this.dataBinder;
    }
}

