/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.accounts.accountfees;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.accounts.accountfees.EditAccountFeeForm;
import nl.strohalm.cyclos.entities.accounts.MemberAccountType;
import nl.strohalm.cyclos.entities.accounts.fees.account.AccountFee;
import nl.strohalm.cyclos.entities.accounts.fees.account.AccountFeeLogQuery;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.GroupQuery;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsChangeListener;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsEvent;
import nl.strohalm.cyclos.services.accountfees.AccountFeeService;
import nl.strohalm.cyclos.services.accounts.AccountTypeService;
import nl.strohalm.cyclos.services.transfertypes.TransferTypeService;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.RequestHelper;
import nl.strohalm.cyclos.utils.TimePeriod;
import nl.strohalm.cyclos.utils.WeekDay;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.DataBinderHelper;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.binding.SimpleCollectionBinder;
import nl.strohalm.cyclos.utils.conversion.IdConverter;
import nl.strohalm.cyclos.utils.conversion.ReferenceConverter;
import nl.strohalm.cyclos.utils.query.PageHelper;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.struts.action.ActionForward;

public class EditAccountFeeAction
extends BaseFormAction
implements LocalSettingsChangeListener {
    private AccountFeeService accountFeeService;
    private AccountTypeService accountTypeService;
    private TransferTypeService transferTypeService;
    private DataBinder<AccountFee> dataBinder;
    private ReadWriteLock lock = new ReentrantReadWriteLock(true);

    public AccountFeeService getAccountFeeService() {
        return this.accountFeeService;
    }

    public AccountTypeService getAccountTypeService() {
        return this.accountTypeService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataBinder<AccountFee> getDataBinder() {
        try {
            this.lock.readLock().lock();
            if (this.dataBinder == null) {
                LocalSettings localSettings = this.settingsService.getLocalSettings();
                BeanBinder<AccountFee> binder = BeanBinder.instance(AccountFee.class);
                binder.registerBinder("id", PropertyBinder.instance(Long.class, "id", IdConverter.instance()));
                binder.registerBinder("accountType", PropertyBinder.instance(MemberAccountType.class, "accountType", ReferenceConverter.instance(MemberAccountType.class)));
                binder.registerBinder("name", PropertyBinder.instance(String.class, "name"));
                binder.registerBinder("description", PropertyBinder.instance(String.class, "description"));
                binder.registerBinder("paymentDirection", PropertyBinder.instance(AccountFee.PaymentDirection.class, "paymentDirection"));
                binder.registerBinder("chargeMode", PropertyBinder.instance(AccountFee.ChargeMode.class, "chargeMode"));
                binder.registerBinder("enabled", PropertyBinder.instance(Boolean.TYPE, "enabled"));
                binder.registerBinder("enabledSince", PropertyBinder.instance(Calendar.class, "enabledSince", localSettings.getRawDateConverter()));
                binder.registerBinder("runMode", PropertyBinder.instance(AccountFee.RunMode.class, "runMode"));
                binder.registerBinder("recurrence", DataBinderHelper.timePeriodBinder("recurrence"));
                binder.registerBinder("day", PropertyBinder.instance(Byte.class, "day"));
                binder.registerBinder("hour", PropertyBinder.instance(Byte.class, "hour"));
                binder.registerBinder("invoiceMode", PropertyBinder.instance(AccountFee.InvoiceMode.class, "invoiceMode"));
                binder.registerBinder("amount", PropertyBinder.instance(BigDecimal.class, "amount", localSettings.getNumberConverter()));
                binder.registerBinder("freeBase", PropertyBinder.instance(BigDecimal.class, "freeBase", localSettings.getNumberConverter()));
                binder.registerBinder("transferType", PropertyBinder.instance(TransferType.class, "transferType", ReferenceConverter.instance(TransferType.class)));
                binder.registerBinder("groups", SimpleCollectionBinder.instance(Group.class, "groups"));
                this.dataBinder = binder;
            }
            DataBinder<AccountFee> dataBinder = this.dataBinder;
            return dataBinder;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public TransferTypeService getTransferTypeService() {
        return this.transferTypeService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onLocalSettingsUpdate(LocalSettingsEvent event) {
        try {
            this.lock.writeLock().lock();
            this.dataBinder = null;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Inject
    public void setAccountFeeService(AccountFeeService accountFeeService) {
        this.accountFeeService = accountFeeService;
    }

    @Inject
    public void setAccountTypeService(AccountTypeService accountTypeService) {
        this.accountTypeService = accountTypeService;
    }

    @Inject
    public void setTransferTypeService(TransferTypeService transferTypeService) {
        this.transferTypeService = transferTypeService;
    }

    @Override
    protected ActionForward handleSubmit(ActionContext context) throws Exception {
        EditAccountFeeForm form = (EditAccountFeeForm)((Object)context.getForm());
        AccountFee accountFee = this.getDataBinder().readFromString(form.getAccountFee());
        boolean isInsert = accountFee.getId() == null;
        accountFee = this.accountFeeService.save(accountFee);
        context.sendMessage(isInsert ? "accountFee.inserted" : "accountFee.modified", new Object[0]);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("accountTypeId", form.getAccountTypeId());
        params.put("accountFeeId", accountFee.getId());
        return ActionHelper.redirectWithParams(context.getRequest(), context.getSuccessForward(), params);
    }

    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        boolean alreadyRan;
        AccountFee accountFee;
        boolean isInsert;
        MemberAccountType accountType;
        HttpServletRequest request = context.getRequest();
        EditAccountFeeForm form = (EditAccountFeeForm)((Object)context.getForm());
        long accountTypeId = form.getAccountTypeId();
        try {
            accountType = (MemberAccountType)this.accountTypeService.load(accountTypeId);
        }
        catch (Exception e) {
            throw new ValidationException();
        }
        long id = form.getAccountFeeId();
        boolean bl = isInsert = id <= 0L;
        if (isInsert) {
            accountFee = new AccountFee();
            alreadyRan = false;
        } else {
            accountFee = this.accountFeeService.load(id, AccountFee.Relationships.GROUPS, AccountFee.Relationships.TRANSFER_TYPE);
            List<TransferType> transferTypes = this.transferTypeService.getPosibleTTsForAccountFee(accountType, accountFee.getPaymentDirection());
            request.setAttribute("transferTypes", transferTypes);
            AccountFeeLogQuery query = new AccountFeeLogQuery();
            query.setPageForCount();
            query.setAccountFee(accountFee);
            alreadyRan = PageHelper.hasResults(this.accountFeeService.searchLogs(query));
        }
        this.getDataBinder().writeAsString(form.getAccountFee(), accountFee);
        GroupQuery groupQuery = new GroupQuery();
        groupQuery.setNatures(Group.Nature.MEMBER, Group.Nature.BROKER);
        groupQuery.setStatus(Group.Status.NORMAL);
        groupQuery.setMemberAccountType(accountType);
        List<? extends Group> groups = this.groupService.search(groupQuery);
        request.setAttribute("accountFee", (Object)accountFee);
        request.setAttribute("isInsert", (Object)isInsert);
        request.setAttribute("alreadyRan", (Object)alreadyRan);
        request.setAttribute("accountType", (Object)accountType);
        request.setAttribute("groups", groups);
        request.setAttribute("recurrenceFields", Arrays.asList(TimePeriod.Field.MONTHS, TimePeriod.Field.WEEKS, TimePeriod.Field.DAYS));
        RequestHelper.storeEnum(request, AccountFee.ChargeMode.class, "chargeModes");
        RequestHelper.storeEnum(request, AccountFee.PaymentDirection.class, "paymentDirections");
        RequestHelper.storeEnum(request, AccountFee.RunMode.class, "runModes");
        RequestHelper.storeEnum(request, AccountFee.InvoiceMode.class, "invoiceModes");
        RequestHelper.storeEnum(request, WeekDay.class, "weekDays");
    }

    @Override
    protected void validateForm(ActionContext context) {
        EditAccountFeeForm form = (EditAccountFeeForm)((Object)context.getForm());
        AccountFee accountFee = this.getDataBinder().readFromString(form.getAccountFee());
        this.accountFeeService.validate(accountFee);
    }
}

