/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.accounts.accountfees;

import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseQueryAction;
import nl.strohalm.cyclos.controls.accounts.accountfees.AccountFeeLogForm;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.accounts.fees.account.AccountFee;
import nl.strohalm.cyclos.entities.accounts.fees.account.AccountFeeLog;
import nl.strohalm.cyclos.entities.accounts.fees.account.AccountFeeLogQuery;
import nl.strohalm.cyclos.entities.accounts.fees.account.AccountFeeQuery;
import nl.strohalm.cyclos.entities.groups.AdminGroup;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.services.accountfees.AccountFeeService;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.DataBinderHelper;
import nl.strohalm.cyclos.utils.query.QueryParameters;

public class ListAccountFeeLogAction
extends BaseQueryAction {
    private AccountFeeService accountFeeService;
    private DataBinder<AccountFeeLogQuery> dataBinder;

    public AccountFeeService getAccountFeeService() {
        return this.accountFeeService;
    }

    @Inject
    public void setAccountFeeService(AccountFeeService accountFeeService) {
        this.accountFeeService = accountFeeService;
    }

    @Override
    protected void executeQuery(ActionContext context, QueryParameters queryParameters) {
        HttpServletRequest request = context.getRequest();
        AccountFeeLogQuery query = (AccountFeeLogQuery)queryParameters;
        List<AccountFeeLog> logs = this.accountFeeService.searchLogs(query);
        request.setAttribute("accountFeeLogs", logs);
    }

    @Override
    protected QueryParameters prepareForm(ActionContext context) {
        HttpServletRequest request = context.getRequest();
        AdminGroup adminGroup = (AdminGroup)context.getGroup();
        adminGroup = (AdminGroup)this.groupService.load(adminGroup.getId(), AdminGroup.Relationships.MANAGES_GROUPS);
        Collection<MemberGroup> managedGroups = adminGroup.getManagesGroups();
        AccountFeeQuery feeQuery = new AccountFeeQuery();
        feeQuery.fetch(AccountFee.Relationships.LOGS, RelationshipHelper.nested(AccountFee.Relationships.ACCOUNT_TYPE, AccountType.Relationships.CURRENCY));
        feeQuery.setReturnDisabled(false);
        feeQuery.setGroups(managedGroups);
        List<AccountFee> fees = this.accountFeeService.search(feeQuery);
        feeQuery.setReturnDisabled(true);
        AccountFeeLogForm form = (AccountFeeLogForm)((Object)context.getForm());
        AccountFeeLogQuery logQuery = this.getDataBinder().readFromString(form.getQuery());
        logQuery.setAccountFees(fees);
        boolean hasRunningFees = false;
        for (AccountFee fee : fees) {
            AccountFeeLog lastExecution = fee.getLastExecution();
            if (lastExecution == null || lastExecution.isFinished()) continue;
            hasRunningFees = true;
            break;
        }
        request.setAttribute("hasRunningFees", (Object)hasRunningFees);
        request.setAttribute("accountFees", fees);
        return logQuery;
    }

    @Override
    protected boolean willExecuteQuery(ActionContext context, QueryParameters queryParameters) throws Exception {
        return true;
    }

    private DataBinder<AccountFeeLogQuery> getDataBinder() {
        if (this.dataBinder == null) {
            BeanBinder<AccountFeeLogQuery> binder = BeanBinder.instance(AccountFeeLogQuery.class);
            binder.registerBinder("pageParameters", DataBinderHelper.pageBinder());
            this.dataBinder = binder;
        }
        return this.dataBinder;
    }
}

