/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.accounts.accounttypes;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.access.AdminSystemPermission;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.accounts.accounttypes.EditAccountTypeForm;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.accounts.Currency;
import nl.strohalm.cyclos.entities.accounts.MemberAccountType;
import nl.strohalm.cyclos.entities.accounts.SystemAccountType;
import nl.strohalm.cyclos.entities.accounts.fees.account.AccountFee;
import nl.strohalm.cyclos.entities.accounts.fees.account.AccountFeeQuery;
import nl.strohalm.cyclos.entities.accounts.transactions.PaymentFilterQuery;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferTypeQuery;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsChangeListener;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsEvent;
import nl.strohalm.cyclos.services.accountfees.AccountFeeService;
import nl.strohalm.cyclos.services.accounts.AccountTypeService;
import nl.strohalm.cyclos.services.accounts.CurrencyService;
import nl.strohalm.cyclos.services.transactions.TransactionContext;
import nl.strohalm.cyclos.services.transfertypes.PaymentFilterService;
import nl.strohalm.cyclos.services.transfertypes.TransferTypeService;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.RequestHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.conversion.IdConverter;
import nl.strohalm.cyclos.utils.validation.RequiredError;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForward;

public class EditAccountTypeAction
extends BaseFormAction
implements LocalSettingsChangeListener {
    private CurrencyService currencyService;
    private AccountTypeService accountTypeService;
    private TransferTypeService transferTypeService;
    private AccountFeeService accountFeeService;
    private PaymentFilterService paymentFilterService;
    private Map<AccountType.Nature, DataBinder<? extends AccountType>> dataBinders;
    private ReadWriteLock lock = new ReentrantReadWriteLock(true);

    public AccountFeeService getAccountFeeService() {
        return this.accountFeeService;
    }

    public AccountTypeService getAccountTypeService() {
        return this.accountTypeService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataBinder<? extends AccountType> getDataBinder(AccountType.Nature nature) {
        try {
            this.lock.readLock().lock();
            if (this.dataBinders == null) {
                HashMap<AccountType.Nature, DataBinder<? extends AccountType>> temp = new HashMap<AccountType.Nature, DataBinder<? extends AccountType>>();
                LocalSettings localSettings = this.settingsService.getLocalSettings();
                BeanBinder<SystemAccountType> systemBinder = BeanBinder.instance(SystemAccountType.class);
                this.initBasic(systemBinder);
                systemBinder.registerBinder("creditLimit", PropertyBinder.instance(BigDecimal.class, "creditLimit", localSettings.getNumberConverter()));
                systemBinder.registerBinder("upperCreditLimit", PropertyBinder.instance(BigDecimal.class, "upperCreditLimit", localSettings.getNumberConverter()));
                temp.put(AccountType.Nature.SYSTEM, systemBinder);
                BeanBinder<MemberAccountType> memberBinder = BeanBinder.instance(MemberAccountType.class);
                this.initBasic(memberBinder);
                temp.put(AccountType.Nature.MEMBER, memberBinder);
                this.dataBinders = temp;
            }
            DataBinder<? extends AccountType> dataBinder = this.dataBinders.get(nature);
            return dataBinder;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public PaymentFilterService getPaymentFilterService() {
        return this.paymentFilterService;
    }

    public TransferTypeService getTransferTypeService() {
        return this.transferTypeService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onLocalSettingsUpdate(LocalSettingsEvent event) {
        try {
            this.lock.writeLock().lock();
            this.dataBinders = null;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Inject
    public void setAccountFeeService(AccountFeeService accountFeeService) {
        this.accountFeeService = accountFeeService;
    }

    @Inject
    public void setAccountTypeService(AccountTypeService accountTypeService) {
        this.accountTypeService = accountTypeService;
    }

    @Inject
    public void setCurrencyService(CurrencyService currencyService) {
        this.currencyService = currencyService;
    }

    @Inject
    public void setPaymentFilterService(PaymentFilterService paymentFilterService) {
        this.paymentFilterService = paymentFilterService;
    }

    @Inject
    public void setTransferTypeService(TransferTypeService transferTypeService) {
        this.transferTypeService = transferTypeService;
    }

    @Override
    protected ActionForward handleSubmit(ActionContext context) throws Exception {
        EditAccountTypeForm form = (EditAccountTypeForm)((Object)context.getForm());
        AccountType accountType = this.resolveAccountType(form);
        boolean isInsert = accountType.getId() == null;
        accountType = this.accountTypeService.save(accountType);
        context.sendMessage(isInsert ? "accountType.inserted" : "accountType.modified", new Object[0]);
        return ActionHelper.redirectWithParam(context.getRequest(), context.getSuccessForward(), "accountTypeId", accountType.getId());
    }

    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        HttpServletRequest request = context.getRequest();
        EditAccountTypeForm form = (EditAccountTypeForm)((Object)context.getForm());
        long id = form.getAccountTypeId();
        boolean isInsert = id <= 0L;
        boolean editable = this.permissionService.hasPermission(AdminSystemPermission.ACCOUNTS_MANAGE);
        boolean isSystem = false;
        if (isInsert) {
            RequestHelper.storeEnum(request, AccountType.Nature.class, "natures");
            RequestHelper.storeEnum(request, AccountType.LimitType.class, "limitTypes");
        } else {
            AccountType accountType = this.accountTypeService.load(id);
            isSystem = accountType instanceof SystemAccountType;
            request.setAttribute("accountType", (Object)accountType);
            this.getDataBinder(accountType.getNature()).writeAsString(form.getAccountType(), accountType);
            TransferTypeQuery ttQuery = new TransferTypeQuery();
            ttQuery.fetch(TransferType.Relationships.FROM, TransferType.Relationships.TO);
            ttQuery.setContext(TransactionContext.ANY);
            ttQuery.setFromAccountType(accountType);
            request.setAttribute("transferTypes", this.transferTypeService.search(ttQuery));
            if (!isSystem) {
                AccountFeeQuery feeQuery = new AccountFeeQuery();
                HashSet<Relationship> fetch = new HashSet<Relationship>();
                fetch.add(RelationshipHelper.nested(AccountFee.Relationships.ACCOUNT_TYPE, AccountType.Relationships.CURRENCY));
                feeQuery.setFetch(fetch);
                feeQuery.setAccountType(accountType);
                feeQuery.setReturnDisabled(true);
                request.setAttribute("accountFees", this.accountFeeService.search(feeQuery));
            }
            PaymentFilterQuery filterQuery = new PaymentFilterQuery();
            filterQuery.setAccountType(accountType);
            request.setAttribute("paymentFilters", this.paymentFilterService.search(filterQuery));
        }
        request.setAttribute("currencies", this.currencyService.listAll());
        request.setAttribute("isInsert", (Object)isInsert);
        request.setAttribute("isSystem", (Object)isSystem);
        request.setAttribute("editable", (Object)editable);
    }

    @Override
    protected void validateForm(ActionContext context) {
        AccountType.Nature nature;
        ValidationException val;
        EditAccountTypeForm form = (EditAccountTypeForm)((Object)context.getForm());
        try {
            this.accountTypeService.validate(this.resolveAccountType(form));
            val = new ValidationException();
            val.setPropertyKey("creditLimit", "account.creditLimit");
        }
        catch (ValidationException e) {
            val = e;
        }
        try {
            nature = AccountType.Nature.valueOf(form.getAccountType("nature").toString());
        }
        catch (Exception e) {
            throw new ValidationException();
        }
        if (nature == AccountType.Nature.SYSTEM && AccountType.LimitType.LIMITED.name().equals(form.getAccountType("limitType")) && StringUtils.isEmpty((String)((String)form.getAccountType("creditLimit")))) {
            val.addPropertyError("creditLimit", new RequiredError(new Object[0]));
        }
        val.throwIfHasErrors();
    }

    private void initBasic(BeanBinder<? extends AccountType> binder) {
        binder.registerBinder("id", PropertyBinder.instance(Long.class, "id", IdConverter.instance()));
        binder.registerBinder("name", PropertyBinder.instance(String.class, "name"));
        binder.registerBinder("description", PropertyBinder.instance(String.class, "description"));
        binder.registerBinder("currency", PropertyBinder.instance(Currency.class, "currency"));
    }

    private AccountType resolveAccountType(EditAccountTypeForm form) {
        AccountType.Nature nature;
        long id = form.getAccountTypeId();
        if (id <= 0L) {
            try {
                nature = AccountType.Nature.valueOf(form.getAccountType("nature").toString());
            }
            catch (Exception e) {
                throw new ValidationException();
            }
        } else {
            nature = this.accountTypeService.load(id).getNature();
        }
        return this.getDataBinder(nature).readFromString(form.getAccountType());
    }
}

