/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.accounts.accounttypes;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseAjaxAction;
import nl.strohalm.cyclos.controls.accounts.accounttypes.SearchAccountTypesAjaxForm;
import nl.strohalm.cyclos.entities.accounts.AccountOwner;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.accounts.Currency;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferTypeQuery;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.services.accounts.AccountTypeService;
import nl.strohalm.cyclos.services.accounts.MemberAccountTypeQuery;
import nl.strohalm.cyclos.services.transactions.TransactionContext;
import nl.strohalm.cyclos.services.transfertypes.TransferTypeService;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.BeanCollectionBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.DataBinderHelper;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.binding.SimpleCollectionBinder;
import nl.strohalm.cyclos.utils.conversion.AccountOwnerConverter;
import nl.strohalm.cyclos.utils.conversion.ReferenceConverter;
import nl.strohalm.cyclos.utils.query.PageHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;

public class SearchAccountTypesAjaxAction
extends BaseAjaxAction {
    private DataBinder<MemberAccountTypeQuery> queryBinder;
    private BeanCollectionBinder<Map<String, Object>> accountTypeBinder;
    private BeanCollectionBinder<Map<String, Object>> accountTypeBinderWithScheduling;
    private AccountTypeService accountTypeService;
    private TransferTypeService transferTypeService;

    public BeanCollectionBinder<Map<String, Object>> getAccountTypeBinder() {
        if (this.accountTypeBinder == null) {
            this.accountTypeBinder = BeanCollectionBinder.instance(DataBinderHelper.accountTypeBinder());
        }
        return this.accountTypeBinder;
    }

    public BeanCollectionBinder<Map<String, Object>> getAccountTypeBinderWithScheduling() {
        if (this.accountTypeBinderWithScheduling == null) {
            BeanBinder<Map<String, Object>> binder = DataBinderHelper.accountTypeBinder();
            binder.registerBinder("allowsScheduledPayments", PropertyBinder.instance(Boolean.TYPE, "allowsScheduledPayments"));
            this.accountTypeBinderWithScheduling = BeanCollectionBinder.instance(binder);
        }
        return this.accountTypeBinderWithScheduling;
    }

    public DataBinder<MemberAccountTypeQuery> getQueryBinder() {
        if (this.queryBinder == null) {
            BeanBinder<MemberAccountTypeQuery> binder = BeanBinder.instance(MemberAccountTypeQuery.class);
            binder.registerBinder("owner", PropertyBinder.instance(Member.class, "ownerId", ReferenceConverter.instance(Member.class)));
            binder.registerBinder("canPay", PropertyBinder.instance(AccountOwner.class, "canPayOwnerId", AccountOwnerConverter.zeroIsSystemInstance()));
            binder.registerBinder("currency", PropertyBinder.instance(Currency.class, "currencyId"));
            binder.registerBinder("relatedToGroups", SimpleCollectionBinder.instance(MemberGroup.class, "memberGroupId"));
            this.queryBinder = binder;
        }
        return this.queryBinder;
    }

    @Inject
    public void setAccountTypeService(AccountTypeService accountTypeService) {
        this.accountTypeService = accountTypeService;
    }

    @Inject
    public void setTransferTypeService(TransferTypeService transferTypeService) {
        this.transferTypeService = transferTypeService;
    }

    @Override
    protected BaseAjaxAction.ContentType contentType() {
        return BaseAjaxAction.ContentType.JSON;
    }

    @Override
    protected void renderContent(ActionContext context) throws Exception {
        BeanCollectionBinder<Map<String, Object>> collectionBinder;
        SearchAccountTypesAjaxForm form = (SearchAccountTypesAjaxForm)((Object)context.getForm());
        MemberAccountTypeQuery query = this.getQueryBinder().readFromString((Object)form);
        List<? extends AccountType> accountTypes = this.accountTypeService.search(query);
        if (form.isScheduling()) {
            AccountTypesWithScheduling transformer = new AccountTypesWithScheduling(query.getCanPay(), query.getOwner());
            CollectionUtils.transform(accountTypes, (Transformer)transformer);
            collectionBinder = this.getAccountTypeBinderWithScheduling();
        } else {
            collectionBinder = this.getAccountTypeBinder();
        }
        String json = ((DataBinder)collectionBinder).readAsString(accountTypes);
        this.responseHelper.writeJSON(context.getResponse(), json);
    }

    private class AccountTypesWithScheduling
    implements Transformer {
        private AccountOwner from;
        private AccountOwner to;

        public AccountTypesWithScheduling(AccountOwner from, AccountOwner to) {
            this.from = from;
            this.to = to;
        }

        public Object transform(Object at) {
            AccountType accountType = (AccountType)at;
            HashMap<String, Object> map = new HashMap<String, Object>();
            TransferTypeQuery ttQuery = new TransferTypeQuery();
            ttQuery.setPageForCount();
            ttQuery.setContext(TransactionContext.PAYMENT);
            ttQuery.setFromOwner(this.from);
            ttQuery.setToOwner(this.to);
            ttQuery.setToAccountType(accountType);
            ttQuery.setSchedulable(true);
            if (this.from instanceof Member) {
                Member member = (Member)SearchAccountTypesAjaxAction.this.elementService.load(((Member)this.from).getId(), Element.Relationships.GROUP);
                ttQuery.setGroup(member.getGroup());
            }
            int count = PageHelper.getTotalCount(SearchAccountTypesAjaxAction.this.transferTypeService.search(ttQuery));
            map.put("id", accountType.getId());
            map.put("name", accountType.getName());
            map.put("currency", accountType.getCurrency());
            map.put("allowsScheduledPayments", count > 0);
            return map;
        }
    }
}

