/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.accounts.authorizationlevels;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.accounts.authorizationlevels.EditAuthorizationLevelForm;
import nl.strohalm.cyclos.entities.accounts.transactions.AuthorizationLevel;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.groups.AdminGroup;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsChangeListener;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsEvent;
import nl.strohalm.cyclos.services.transfertypes.AuthorizationLevelService;
import nl.strohalm.cyclos.services.transfertypes.TransferTypeService;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.binding.SimpleCollectionBinder;
import nl.strohalm.cyclos.utils.conversion.IdConverter;
import nl.strohalm.cyclos.utils.conversion.ReferenceConverter;
import org.apache.struts.action.ActionForward;

public class EditAuthorizationLevelAction
extends BaseFormAction
implements LocalSettingsChangeListener {
    private AuthorizationLevelService authorizationLevelService;
    private TransferTypeService transferTypeService;
    private DataBinder<AuthorizationLevel> dataBinder;
    private ReadWriteLock lock = new ReentrantReadWriteLock(true);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataBinder<AuthorizationLevel> getDataBinder() {
        try {
            this.lock.readLock().lock();
            if (this.dataBinder == null) {
                LocalSettings localSettings = this.settingsService.getLocalSettings();
                BeanBinder<AuthorizationLevel> binder = BeanBinder.instance(AuthorizationLevel.class);
                binder.registerBinder("id", PropertyBinder.instance(Long.class, "id", IdConverter.instance()));
                binder.registerBinder("amount", PropertyBinder.instance(BigDecimal.class, "amount", localSettings.getNumberConverter()));
                binder.registerBinder("level", PropertyBinder.instance(Integer.class, "level"));
                binder.registerBinder("authorizer", PropertyBinder.instance(AuthorizationLevel.Authorizer.class, "authorizer"));
                binder.registerBinder("transferType", PropertyBinder.instance(TransferType.class, "transferType", ReferenceConverter.instance(TransferType.class)));
                binder.registerBinder("adminGroups", SimpleCollectionBinder.instance(AdminGroup.class, "adminGroups"));
                this.dataBinder = binder;
            }
            DataBinder<AuthorizationLevel> dataBinder = this.dataBinder;
            return dataBinder;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onLocalSettingsUpdate(LocalSettingsEvent event) {
        try {
            this.lock.writeLock().lock();
            this.dataBinder = null;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Inject
    public void setAuthorizationLevelService(AuthorizationLevelService authorizationLevelService) {
        this.authorizationLevelService = authorizationLevelService;
    }

    @Inject
    public void setTransferTypeService(TransferTypeService transferTypeService) {
        this.transferTypeService = transferTypeService;
    }

    @Override
    protected ActionForward handleSubmit(ActionContext context) throws Exception {
        EditAuthorizationLevelForm form = (EditAuthorizationLevelForm)((Object)context.getForm());
        AuthorizationLevel authorizationLevel = this.getDataBinder().readFromString(form.getAuthorizationLevel());
        boolean isInsert = authorizationLevel.isTransient();
        authorizationLevel = this.authorizationLevelService.save(authorizationLevel);
        context.sendMessage(isInsert ? "authorizationLevel.inserted" : "authorizationLevel.modified", new Object[0]);
        HashMap<String, Object> params = new HashMap<String, Object>();
        TransferType transferType = authorizationLevel.getTransferType();
        transferType = this.transferTypeService.load(transferType.getId(), TransferType.Relationships.FROM);
        Long accountTypeId = transferType.getFrom().getId();
        params.put("transferTypeId", transferType.getId());
        params.put("accountTypeId", accountTypeId);
        return ActionHelper.redirectWithParams(context.getRequest(), context.getSuccessForward(), params);
    }

    @Override
    protected void validateForm(ActionContext context) {
        EditAuthorizationLevelForm form = (EditAuthorizationLevelForm)((Object)context.getForm());
        AuthorizationLevel authorizationLevel = this.getDataBinder().readFromString(form.getAuthorizationLevel());
        this.authorizationLevelService.validate(authorizationLevel);
    }
}

