/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.accounts.cards;

import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.access.BrokerPermission;
import nl.strohalm.cyclos.access.MemberPermission;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.accounts.cards.CardForm;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.access.User;
import nl.strohalm.cyclos.entities.accounts.cards.Card;
import nl.strohalm.cyclos.entities.accounts.cards.CardLog;
import nl.strohalm.cyclos.entities.accounts.cards.CardQuery;
import nl.strohalm.cyclos.entities.accounts.cards.CardType;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsChangeListener;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsEvent;
import nl.strohalm.cyclos.services.accounts.cards.CardService;
import nl.strohalm.cyclos.services.permissions.PermissionService;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.RangeConstraint;
import nl.strohalm.cyclos.utils.access.PermissionHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.DataBinderHelper;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.binding.SimpleCollectionBinder;
import nl.strohalm.cyclos.utils.validation.ValidationException;

public class CardDetailsAction
extends BaseFormAction
implements LocalSettingsChangeListener {
    private DataBinder<CardQuery> dataBinder;
    protected CardService cardService;
    private ReadWriteLock lock = new ReentrantReadWriteLock(true);

    public CardService getCardService() {
        return this.cardService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataBinder<CardQuery> getDataBinder() {
        try {
            this.lock.readLock().lock();
            if (this.dataBinder == null) {
                LocalSettings localSettings = this.settingsService.getLocalSettings();
                BeanBinder<CardQuery> binder = BeanBinder.instance(CardQuery.class);
                binder.registerBinder("groups", SimpleCollectionBinder.instance(Group.class, "groups"));
                binder.registerBinder("status", SimpleCollectionBinder.instance(Card.Status.class, "status"));
                binder.registerBinder("expiration", DataBinderHelper.periodBinder(localSettings, "expiration"));
                binder.registerBinder("member", PropertyBinder.instance(Member.class, "member"));
                binder.registerBinder("number", PropertyBinder.instance(Card.class, "number"));
                this.dataBinder = binder;
            }
            DataBinder<CardQuery> dataBinder = this.dataBinder;
            return dataBinder;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onLocalSettingsUpdate(LocalSettingsEvent event) {
        try {
            this.lock.writeLock().lock();
            this.dataBinder = null;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Inject
    public void setCardService(CardService cardService) {
        this.cardService = cardService;
    }

    @Override
    protected void prepareForm(ActionContext context) {
        CardForm form = (CardForm)((Object)context.getForm());
        HttpServletRequest request = context.getRequest();
        long cardId = form.getCardId();
        String listOnly = form.getListOnly();
        boolean canBlock = false;
        boolean canUnblock = false;
        boolean canActivate = false;
        boolean canCancel = false;
        boolean canChangeCode = false;
        boolean canUnblockSecurityCode = false;
        boolean showUnblockSecurityCodeButton = false;
        PermissionService pService = this.permissionService;
        try {
            boolean isCardBlocked;
            Card card;
            if (cardId > 0L) {
                card = this.cardService.load(cardId, Element.Relationships.USER);
                if (!context.isBroker() && !context.isAdmin() && !card.getOwner().equals(context.getAccountOwner()) || context.isBroker() && !context.isBrokerOf(card.getOwner()) && !card.getOwner().equals(context.getAccountOwner())) {
                    throw new ValidationException();
                }
            } else {
                throw new ValidationException();
            }
            Class enumType = null;
            if (context.isAdmin()) {
                enumType = AdminMemberPermission.class;
            } else if (context.isBrokerOf(card.getOwner())) {
                enumType = BrokerPermission.class;
            } else if (context.isMember() && card.getOwner().equals(context.getAccountOwner())) {
                enumType = MemberPermission.class;
            }
            if (enumType != null) {
                switch (card.getStatus()) {
                    case ACTIVE: {
                        canBlock = pService.hasPermission(PermissionHelper.find(AdminMemberPermission.CARDS_BLOCK, enumType));
                        break;
                    }
                    case BLOCKED: {
                        canUnblock = pService.hasPermission(PermissionHelper.find(AdminMemberPermission.CARDS_UNBLOCK, enumType));
                        break;
                    }
                    case PENDING: {
                        canActivate = pService.hasPermission(PermissionHelper.find(AdminMemberPermission.CARDS_UNBLOCK, enumType));
                    }
                }
                canChangeCode = pService.hasPermission(PermissionHelper.find(AdminMemberPermission.CARDS_CHANGE_CARD_SECURITY_CODE, enumType));
                if (enumType != MemberPermission.class) {
                    canCancel = pService.hasPermission(PermissionHelper.find(AdminMemberPermission.CARDS_CANCEL, enumType));
                    canUnblockSecurityCode = pService.hasPermission(PermissionHelper.find(AdminMemberPermission.CARDS_UNBLOCK_SECURITY_CODE, enumType));
                }
            }
            if (card.getCardType().getCardSecurityCode() == CardType.CardSecurityCode.NOT_USED) {
                canChangeCode = false;
            }
            boolean isAutomaticCardCode = false;
            if (card.getCardType().getCardSecurityCode() == CardType.CardSecurityCode.AUTOMATIC) {
                isAutomaticCardCode = true;
                canChangeCode = false;
            }
            if (card.getStatus() == Card.Status.PENDING) {
                canChangeCode = false;
            }
            if (card.getStatus() == Card.Status.CANCELED || card.getStatus() == Card.Status.EXPIRED) {
                canCancel = false;
                canChangeCode = false;
            }
            if (isCardBlocked = this.accessService.isCardSecurityCodeBlocked(card)) {
                showUnblockSecurityCodeButton = canUnblockSecurityCode;
                canChangeCode = false;
            }
            ActionHelper.ByElementExtractor extractor = new ActionHelper.ByElementExtractor(){

                @Override
                public Element getByElement(Entity entity) {
                    return ((CardLog)entity).getBy();
                }
            };
            request.setAttribute("card", (Object)card);
            request.setAttribute("cardId", (Object)card.getId());
            request.setAttribute("canBlock", (Object)canBlock);
            request.setAttribute("canUnblock", (Object)canUnblock);
            request.setAttribute("canActivate", (Object)canActivate);
            request.setAttribute("canCancel", (Object)canCancel);
            request.setAttribute("canChangeCode", (Object)canChangeCode);
            request.setAttribute("isAutomaticCardCode", (Object)isAutomaticCardCode);
            request.setAttribute("isManualCardCode", (Object)(card.getCardType().getCardSecurityCode() == CardType.CardSecurityCode.MANUAL ? 1 : 0));
            request.setAttribute("isAdmin", (Object)context.isAdmin());
            request.setAttribute("showUnblockSecurityCodeButton", (Object)showUnblockSecurityCodeButton);
            request.setAttribute("listOnly", (Object)listOnly);
            request.setAttribute("memberId", (Object)card.getOwner().getId());
            request.setAttribute("hasActiveCard", (Object)(this.cardService.getActiveCard(card.getOwner()) != null ? 1 : 0));
            request.setAttribute("isCardBlocked", (Object)isCardBlocked);
            request.setAttribute("showCardSecurityCode", (Object)card.getCardType().isShowCardSecurityCode());
            request.setAttribute("logsBy", ActionHelper.getByElements(context, card.getLogs(), extractor));
            boolean usesTransactionPassword = context.isTransactionPasswordEnabled();
            boolean transactionPasswordBlocked = false;
            boolean transactionPasswordPending = false;
            if (usesTransactionPassword) {
                User.TransactionPasswordStatus transactionPasswordStatus = ((User)this.elementService.reloadUser(((Entity)context.getUser()).getId(), new Relationship[0])).getTransactionPasswordStatus();
                if (transactionPasswordStatus == User.TransactionPasswordStatus.BLOCKED) {
                    transactionPasswordBlocked = true;
                } else if (transactionPasswordStatus.isGenerationAllowed()) {
                    transactionPasswordPending = true;
                }
            }
            request.setAttribute("usesTransactionPassword", (Object)usesTransactionPassword);
            request.setAttribute("transactionPasswordBlocked", (Object)transactionPasswordBlocked);
            request.setAttribute("transactionPasswordPending", (Object)transactionPasswordPending);
            RangeConstraint range = card.getCardType().getCardSecurityCodeLength();
            request.setAttribute("minPasswordLength", (Object)range.getMin());
            request.setAttribute("maxPasswordLength", (Object)range.getMax());
        }
        catch (Exception e) {
            throw new ValidationException();
        }
    }
}

