/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.accounts.cards;

import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.accounts.cards.CardForm;
import nl.strohalm.cyclos.entities.accounts.cards.Card;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsEvent;
import nl.strohalm.cyclos.services.accounts.cards.CardService;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.DataBinderHelper;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.binding.SimpleCollectionBinder;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.struts.action.ActionForward;

public class CreateCardAction
extends BaseFormAction {
    protected CardService cardService;
    private DataBinder<Card> dataBinder;

    public CardService getCardService() {
        return this.cardService;
    }

    public DataBinder<Card> getDataBinder() {
        if (this.dataBinder == null) {
            LocalSettings localSettings = this.settingsService.getLocalSettings();
            BeanBinder<Card> binder = BeanBinder.instance(Card.class);
            binder.registerBinder("groups", SimpleCollectionBinder.instance(Group.class, "groups"));
            binder.registerBinder("status", SimpleCollectionBinder.instance(Card.Status.class, "status"));
            binder.registerBinder("expiration", DataBinderHelper.periodBinder(localSettings, "expiration"));
            binder.registerBinder("member", PropertyBinder.instance(Member.class, "member"));
            binder.registerBinder("number", PropertyBinder.instance(Card.class, "number"));
            this.dataBinder = binder;
        }
        return this.dataBinder;
    }

    public void onLocalSettingsUpdate(LocalSettingsEvent event) {
        this.dataBinder = null;
    }

    @Inject
    public void setCardService(CardService cardService) {
        this.cardService = cardService;
    }

    @Override
    protected ActionForward handleSubmit(ActionContext context) throws Exception {
        CardForm form = (CardForm)((Object)context.getForm());
        long memberId = form.getMemberId();
        Member member = null;
        try {
            if (memberId > 0L && (member = (Member)this.elementService.load(memberId, Element.Relationships.USER, RelationshipHelper.nested(Element.Relationships.GROUP))) == null) {
                throw new Exception();
            }
            Card card = this.cardService.generateNewCard(member);
            ActionForward forward = context.findForward("view");
            TreeMap<String, Object> params = new TreeMap<String, Object>();
            params.put("cardId", card.getId());
            params.put("listOnly", form.getListOnly());
            context.sendMessage("card.created", new Object[0]);
            return ActionHelper.redirectWithParams(context.getRequest(), forward, params);
        }
        catch (Exception e) {
            throw new ValidationException();
        }
    }

    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        HttpServletRequest request = context.getRequest();
        CardForm form = (CardForm)((Object)context.getForm());
        long memberId = form.getMemberId();
        Member member = null;
        try {
            if (memberId > 0L && (member = (Member)this.elementService.load(memberId, Element.Relationships.USER, RelationshipHelper.nested(Element.Relationships.GROUP))) == null) {
                throw new Exception();
            }
            request.setAttribute("member", member);
        }
        catch (Exception e) {
            throw new ValidationException();
        }
    }
}

