/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.accounts.cards;

import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.access.AdminSystemPermission;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.accounts.cards.EditCardTypeForm;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.cards.CardType;
import nl.strohalm.cyclos.services.accounts.cards.CardTypeService;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.RequestHelper;
import nl.strohalm.cyclos.utils.TimePeriod;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.DataBinderHelper;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.conversion.IdConverter;
import org.apache.struts.action.ActionForward;

public class EditCardTypeAction
extends BaseFormAction {
    private CardTypeService cardTypeService;
    private DataBinder<CardType> writeDataBinder;

    public CardTypeService getCardTypeService() {
        return this.cardTypeService;
    }

    public DataBinder<CardType> getWriteDataBinder() {
        if (this.writeDataBinder == null) {
            BeanBinder<CardType> binder = BeanBinder.instance(CardType.class);
            binder.registerBinder("id", PropertyBinder.instance(Long.class, "id", IdConverter.instance()));
            binder.registerBinder("name", PropertyBinder.instance(String.class, "name"));
            binder.registerBinder("cardFormatNumber", PropertyBinder.instance(String.class, "cardFormatNumber"));
            binder.registerBinder("defaultExpiration", DataBinderHelper.timePeriodBinder("defaultExpiration"));
            binder.registerBinder("securityCodeBlockTime", DataBinderHelper.timePeriodBinder("securityCodeBlockTime"));
            binder.registerBinder("cardSecurityCode", PropertyBinder.instance(CardType.CardSecurityCode.class, "cardSecurityCode"));
            binder.registerBinder("showCardSecurityCode", PropertyBinder.instance(Boolean.TYPE, "showCardSecurityCode"));
            binder.registerBinder("ignoreDayInExpirationDate", PropertyBinder.instance(Boolean.TYPE, "ignoreDayInExpirationDate"));
            binder.registerBinder("cardSecurityCodeLength", DataBinderHelper.rangeConstraintBinder("cardSecurityCodeLength"));
            binder.registerBinder("maxSecurityCodeTries", PropertyBinder.instance(Integer.class, "maxSecurityCodeTries"));
            this.writeDataBinder = binder;
        }
        return this.writeDataBinder;
    }

    @Inject
    public void setCardTypeService(CardTypeService cardTypeService) {
        this.cardTypeService = cardTypeService;
    }

    @Override
    protected ActionForward handleSubmit(ActionContext context) throws Exception {
        EditCardTypeForm form = (EditCardTypeForm)((Object)context.getForm());
        CardType cardType = this.getWriteDataBinder().readFromString(form.getCardType());
        boolean isInsert = cardType.isTransient();
        cardType = this.cardTypeService.save(cardType);
        if (isInsert) {
            context.sendMessage("cardType.inserted", new Object[0]);
        } else {
            context.sendMessage("cardType.modified", new Object[0]);
        }
        return ActionHelper.redirectWithParam(context.getRequest(), context.getSuccessForward(), "cardTypeId", cardType.getId());
    }

    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        CardType cardType;
        boolean isInsert;
        HttpServletRequest request = context.getRequest();
        EditCardTypeForm form = (EditCardTypeForm)((Object)context.getForm());
        long cardTypeId = form.getCardTypeId();
        boolean hasCardGenerated = false;
        boolean editable = this.permissionService.hasPermission(AdminSystemPermission.CARD_TYPES_MANAGE);
        boolean bl = isInsert = cardTypeId <= 0L;
        if (isInsert) {
            cardType = new CardType();
            editable = true;
        } else {
            cardType = this.cardTypeService.load(cardTypeId, new Relationship[0]);
            hasCardGenerated = this.cardTypeService.hasCards(cardTypeId);
        }
        this.getWriteDataBinder().writeAsString(form.getCardType(), cardType);
        request.setAttribute("cardType", (Object)cardType);
        request.setAttribute("isInsert", (Object)isInsert);
        request.setAttribute("editable", (Object)editable);
        request.setAttribute("hasCardGenerated", (Object)hasCardGenerated);
        request.setAttribute("defaultExpirations", Arrays.asList(TimePeriod.Field.MONTHS, TimePeriod.Field.YEARS));
        request.setAttribute("securityCodeBlockTime", Arrays.asList(TimePeriod.Field.MINUTES, TimePeriod.Field.HOURS, TimePeriod.Field.DAYS));
        RequestHelper.storeEnum(request, CardType.CardSecurityCode.class, "cardSecurityCodes");
    }

    @Override
    protected void validateForm(ActionContext context) {
        EditCardTypeForm form = (EditCardTypeForm)((Object)context.getForm());
        CardType cardType = this.getWriteDataBinder().readFromString(form.getCardType());
        this.cardTypeService.validate(cardType);
    }
}

