/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.accounts.cards;

import java.util.List;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseCsvAction;
import nl.strohalm.cyclos.controls.accounts.cards.SearchCardsAction;
import nl.strohalm.cyclos.controls.accounts.cards.SearchCardsForm;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.access.User;
import nl.strohalm.cyclos.entities.accounts.cards.Card;
import nl.strohalm.cyclos.entities.accounts.cards.CardQuery;
import nl.strohalm.cyclos.entities.accounts.cards.CardType;
import nl.strohalm.cyclos.entities.customization.fields.MemberCustomField;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.services.accounts.cards.CardService;
import nl.strohalm.cyclos.services.accounts.cards.CardTypeService;
import nl.strohalm.cyclos.services.customization.MemberCustomFieldService;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.DataBinderHelper;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.binding.SimpleCollectionBinder;
import nl.strohalm.cyclos.utils.conversion.CoercionHelper;
import nl.strohalm.cyclos.utils.conversion.CustomFieldConverter;
import nl.strohalm.cyclos.utils.csv.CSVWriter;
import nl.strohalm.cyclos.utils.query.QueryParameters;

public class ExportCardsToCsvAction
extends BaseCsvAction {
    private CardTypeService cardTypeService;
    private DataBinder<CardQuery> dataBinder;
    protected CardService cardService;
    protected MemberCustomFieldService memberCustomFieldService;

    public CardService getCardService() {
        return this.cardService;
    }

    public DataBinder<CardQuery> getDataBinder() {
        if (this.dataBinder == null) {
            LocalSettings localSettings = this.settingsService.getLocalSettings();
            BeanBinder<CardQuery> binder = BeanBinder.instance(CardQuery.class);
            binder.registerBinder("groups", SimpleCollectionBinder.instance(Group.class, "groups"));
            binder.registerBinder("status", SimpleCollectionBinder.instance(Card.Status.class, "status"));
            binder.registerBinder("expiration", DataBinderHelper.periodBinder(localSettings, "expiration"));
            binder.registerBinder("member", PropertyBinder.instance(Member.class, "member"));
            binder.registerBinder("number", PropertyBinder.instance(Card.class, "number"));
            binder.registerBinder("cardType", PropertyBinder.instance(CardType.class, "cardType"));
            binder.registerBinder("customValues", SimpleCollectionBinder.instance(MemberCustomField.class, "customValues"));
            this.dataBinder = binder;
        }
        return this.dataBinder;
    }

    public MemberCustomFieldService getMemberCustomFieldService() {
        return this.memberCustomFieldService;
    }

    @Inject
    public void setCardService(CardService cardService) {
        this.cardService = cardService;
    }

    @Inject
    public void setCardTypeService(CardTypeService cardTypeService) {
        this.cardTypeService = cardTypeService;
    }

    @Inject
    public void setMemberCustomFieldService(MemberCustomFieldService memberCustomFieldService) {
        this.memberCustomFieldService = memberCustomFieldService;
    }

    protected List<Card> executeQuery(ActionContext context) {
        SearchCardsForm form = (SearchCardsForm)((Object)context.getForm());
        CardQuery query = this.getDataBinder().readFromString(form.getQuery());
        query.setResultType(QueryParameters.ResultType.ITERATOR);
        SearchCardsAction.prepareQuery(context, query, this.elementService, this.groupService);
        List<Card> cards = this.cardService.search(query);
        return cards;
    }

    @Override
    protected String fileName(ActionContext context) {
        Object loggedUser = context.getUser();
        return "cards_" + ((User)loggedUser).getUsername() + ".csv";
    }

    protected CSVWriter resolveCSVWriter(ActionContext context) {
        SearchCardsForm form = (SearchCardsForm)((Object)context.getForm());
        CardType cardType = CoercionHelper.coerce(CardType.class, form.getQuery("cardType"));
        if (cardType == null) {
            List<CardType> cardTypes = this.cardTypeService.listAll();
            cardType = cardTypes.get(0);
        }
        cardType = this.cardTypeService.load(cardType.getId(), new Relationship[0]);
        LocalSettings settings = this.settingsService.getLocalSettings();
        CSVWriter<Card> csv = CSVWriter.instance(Card.class, settings);
        csv.addColumn(context.message("card.member", new Object[0]), "owner.name");
        csv.addColumn(context.message("member.username", new Object[0]), "owner.username");
        csv.addColumn(context.message("card.number", new Object[0]), "cardNumber", cardType.getCardNumberConverter());
        csv.addColumn(context.message("card.expirationDate", new Object[0]), "expirationDate", settings.getRawDateConverter());
        csv.addColumn(context.message("card.group", new Object[0]), "owner.group.name");
        List customFields = this.memberCustomFieldService.list();
        for (MemberCustomField field : customFields) {
            csv.addColumn(field.getName(), "owner.customValues", new CustomFieldConverter(field, this.elementService, settings));
        }
        if (cardType.getCardSecurityCode().equals(CardType.CardSecurityCode.AUTOMATIC)) {
            csv.addColumn(context.message("cardType.cardSecurityCode", new Object[0]), "cardSecurityCode");
        }
        return csv;
    }
}

