/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.accounts.cards;

import java.math.BigInteger;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseQueryAction;
import nl.strohalm.cyclos.controls.accounts.cards.SearchCardsForm;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.cards.Card;
import nl.strohalm.cyclos.entities.accounts.cards.CardQuery;
import nl.strohalm.cyclos.entities.accounts.cards.CardType;
import nl.strohalm.cyclos.entities.groups.AdminGroup;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.GroupFilterQuery;
import nl.strohalm.cyclos.entities.groups.GroupQuery;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsChangeListener;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsEvent;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.accounts.cards.CardService;
import nl.strohalm.cyclos.services.accounts.cards.CardTypeService;
import nl.strohalm.cyclos.services.elements.ElementService;
import nl.strohalm.cyclos.services.groups.GroupService;
import nl.strohalm.cyclos.utils.RequestHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.DataBinderHelper;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.binding.SimpleCollectionBinder;
import nl.strohalm.cyclos.utils.query.QueryParameters;

public abstract class SearchCardsAction
extends BaseQueryAction
implements LocalSettingsChangeListener {
    private DataBinder<CardQuery> dataBinder;
    protected CardService cardService;
    protected CardTypeService cardTypeService;
    private ReadWriteLock lock = new ReentrantReadWriteLock(true);

    public static boolean prepareQuery(ActionContext context, CardQuery query, ElementService elementService, GroupService groupService) {
        boolean listOnly = true;
        HttpServletRequest request = context.getRequest();
        SearchCardsForm form = (SearchCardsForm)((Object)context.getForm());
        long memberId = form.getMemberId();
        if (RequestHelper.isGet(request)) {
            query.setStatus(Collections.singleton(Card.Status.ACTIVE));
        }
        GroupFilterQuery groupFilterQuery = new GroupFilterQuery();
        GroupQuery groupQuery = new GroupQuery();
        if (RequestHelper.isFromMenu(request)) {
            request.setAttribute("isFromMenu", (Object)true);
        } else {
            request.setAttribute("isFromMenu", (Object)false);
        }
        if (context.isAdmin()) {
            AdminGroup adminGroup = (AdminGroup)context.getGroup();
            groupFilterQuery.setAdminGroup(adminGroup);
            groupQuery.setNatures(Group.Nature.MEMBER, Group.Nature.BROKER);
            groupQuery.setManagedBy(adminGroup);
            List<? extends Group> groups = groupService.search(groupQuery);
            if (groups.isEmpty()) {
                throw new PermissionDeniedException();
            }
            request.setAttribute("groups", groups);
            listOnly = false;
            if (query.getGroups() != null) {
                Iterator<MemberGroup> iterator = query.getGroups().iterator();
                while (iterator.hasNext()) {
                    if (groups.contains(iterator.next())) continue;
                    iterator.remove();
                }
            }
            if (query.getGroups().size() == 0) {
                query.setGroups(groups);
            }
        }
        Member member = null;
        if (memberId > 0L) {
            if (RequestHelper.isFromMenu(request)) {
                request.setAttribute("isFromMenu", (Object)true);
            }
            member = (Member)elementService.load(memberId, new Relationship[0]);
        }
        if (query.getMember() != null) {
            Member member2 = (Member)elementService.load(query.getMember().getId(), new Relationship[0]);
            query.setMember(member2);
        }
        if (context.isBroker()) {
            listOnly = false;
            request.setAttribute("isBroker", (Object)true);
            if (memberId > 0L) {
                if (!member.equals(context.getElement())) {
                    query.setBroker((Member)context.getElement());
                }
            } else {
                query.setBroker((Member)context.getElement());
            }
        }
        if (!(context.isMember() && memberId != 0L || !context.isMember() || context.isBroker() || memberId != 0L)) {
            throw new PermissionDeniedException();
        }
        if (memberId > 0L) {
            if (!context.isBroker() && !context.isAdmin() && !member.equals(context.getElement()) || context.isBroker() && !context.isBrokerOf(member) && !member.equals(context.getElement())) {
                throw new PermissionDeniedException();
            }
            query.setMember(member);
            listOnly = true;
            request.setAttribute("member", (Object)member);
            request.setAttribute("cardOwner", (Object)member.getId());
        } else {
            request.setAttribute("cardOwner", (Object)0);
        }
        if (listOnly) {
            query.setStatus(null);
        }
        return listOnly;
    }

    public CardService getCardService() {
        return this.cardService;
    }

    public CardTypeService getCardTypeService() {
        return this.cardTypeService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataBinder<CardQuery> getDataBinder() {
        try {
            this.lock.readLock().lock();
            if (this.dataBinder == null) {
                LocalSettings localSettings = this.settingsService.getLocalSettings();
                BeanBinder<CardQuery> binder = BeanBinder.instance(CardQuery.class);
                binder.registerBinder("groups", SimpleCollectionBinder.instance(Group.class, "groups"));
                binder.registerBinder("status", SimpleCollectionBinder.instance(Card.Status.class, "status"));
                binder.registerBinder("expiration", DataBinderHelper.rawPeriodBinder(localSettings, "expiration"));
                binder.registerBinder("member", PropertyBinder.instance(Member.class, "member"));
                binder.registerBinder("number", PropertyBinder.instance(BigInteger.class, "number"));
                binder.registerBinder("cardType", PropertyBinder.instance(CardType.class, "cardType"));
                binder.registerBinder("pageParameters", DataBinderHelper.pageBinder());
                this.dataBinder = binder;
            }
            DataBinder<CardQuery> dataBinder = this.dataBinder;
            return dataBinder;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onLocalSettingsUpdate(LocalSettingsEvent event) {
        try {
            this.lock.writeLock().lock();
            super.onLocalSettingsUpdate(event);
            this.dataBinder = null;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Inject
    public void setCardService(CardService cardService) {
        this.cardService = cardService;
    }

    @Inject
    public void setCardTypeService(CardTypeService cardTypeService) {
        this.cardTypeService = cardTypeService;
    }

    @Override
    protected void executeQuery(ActionContext context, QueryParameters queryParameters) {
        CardQuery query = (CardQuery)queryParameters;
        List<Card> cards = this.cardService.search(query);
        context.getRequest().setAttribute("cards", cards);
    }

    @Override
    protected QueryParameters prepareForm(ActionContext context) {
        SearchCardsForm form = (SearchCardsForm)((Object)context.getForm());
        CardQuery query = this.getDataBinder().readFromString(form.getQuery());
        boolean listOnly = SearchCardsAction.prepareQuery(context, query, this.elementService, this.groupService);
        HttpServletRequest request = context.getRequest();
        RequestHelper.storeEnum(request, Card.Status.class, "status");
        List<CardType> cardTypes = this.cardTypeService.listAll();
        request.setAttribute("cardTypes", cardTypes);
        request.setAttribute("listOnly", (Object)listOnly);
        request.setAttribute("isAdmin", (Object)context.isAdmin());
        return query;
    }

    @Override
    protected boolean willExecuteQuery(ActionContext context, QueryParameters queryParameters) throws Exception {
        CardQuery query = (CardQuery)queryParameters;
        return query.getMember() != null && query.getMember().getId() > 0L || RequestHelper.isFromMenu(context.getRequest()) || RequestHelper.isPost(context.getRequest());
    }
}

