/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.accounts.cards;

import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.accounts.cards.CardForm;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.access.Channel;
import nl.strohalm.cyclos.entities.accounts.cards.Card;
import nl.strohalm.cyclos.entities.accounts.cards.CardType;
import nl.strohalm.cyclos.services.access.exceptions.BlockedCredentialsException;
import nl.strohalm.cyclos.services.access.exceptions.InvalidCredentialsException;
import nl.strohalm.cyclos.services.accounts.cards.CardService;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.validation.RequiredError;
import nl.strohalm.cyclos.utils.validation.ValidationError;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForward;

public class UpdateCardAction
extends BaseFormAction {
    private CardService cardService;

    public CardService getCardService() {
        return this.cardService;
    }

    @Inject
    public void setCardService(CardService cardService) {
        this.cardService = cardService;
    }

    @Override
    protected ActionForward handleSubmit(ActionContext context) throws Exception {
        HttpServletRequest request = context.getRequest();
        CardForm form = (CardForm)((Object)context.getForm());
        String code = form.getSecurityCode();
        String password = form.getPassword();
        long cardId = form.getCardId();
        Card card = this.cardService.load(cardId, new Relationship[0]);
        try {
            String operation;
            boolean usesTransactionPassword = context.isTransactionPasswordEnabled();
            if (usesTransactionPassword) {
                this.accessService.checkTransactionPassword(password);
            }
            if ((operation = form.getOperation()).equals("block")) {
                this.cardService.blockCard(card);
                context.sendMessage("card.blocked", new Object[0]);
            } else if (operation.equals("unblock")) {
                this.cardService.unblockCard(card);
                context.sendMessage("card.unblocked", new Object[0]);
            } else if (operation.equals("activate")) {
                this.cardService.activateCard(card, code);
                context.sendMessage("card.activated", new Object[0]);
            } else if (operation.equals("cancel")) {
                this.cardService.cancelCard(card);
                context.sendMessage("card.canceled", new Object[0]);
            } else if (operation.equals("changeCardCode")) {
                this.cardService.changeCardCode(card, code);
                context.sendMessage("card.cardCodeChanged", new Object[0]);
            } else if (operation.equals("unblockSecurityCode")) {
                this.cardService.unblockSecurityCode(card);
                context.sendMessage("card.securityCodeUnblocked", new Object[0]);
            } else {
                throw new ValidationException();
            }
            return ActionHelper.redirectWithParam(context.getRequest(), context.getSuccessForward(), "cardId", cardId);
        }
        catch (InvalidCredentialsException e) {
            return context.sendError("card.updateCard.error.invalidTransactionPassword", new Object[0]);
        }
        catch (BlockedCredentialsException e) {
            if (e.getCredentialsType() == Channel.Credentials.TRANSACTION_PASSWORD) {
                context.getSession().setAttribute("returnTo", (Object)(context.getPathPrefix() + "/manageExternalAcccess"));
                return context.sendError("card.updateCard.error.blockedTransactionPassword", new Object[0]);
            }
            request.getSession().invalidate();
            return context.sendError("card.updateCard.error.userBlocked", new Object[0]);
        }
    }

    @Override
    protected void validateForm(ActionContext context) {
        boolean cardWithManualCodeActivation;
        CardForm form = (CardForm)((Object)context.getForm());
        boolean usesTransactionPassword = context.isTransactionPasswordEnabled();
        ValidationException e = new ValidationException();
        e.setPropertyKey("securityCode", "card.changeCardCode.newCode1");
        e.setPropertyKey("securityCodeConfirmation", "card.changeCardCode.newCode2");
        e.setPropertyKey("login.transactionPassword", "login.transactionPassword");
        if (usesTransactionPassword) {
            context.validateTransactionPassword();
            if (StringUtils.isEmpty((String)form.getPassword())) {
                e.addPropertyError("login.transactionPassword", new RequiredError(new Object[0]));
            }
        }
        String operation = form.getOperation();
        Card card = this.cardService.load(form.getCardId(), Card.Relationships.CARD_TYPE);
        boolean bl = cardWithManualCodeActivation = card.getCardType().getCardSecurityCode() == CardType.CardSecurityCode.MANUAL && operation.equals("activate");
        if (operation.equals("changeCardCode") || cardWithManualCodeActivation) {
            String securityCode = form.getSecurityCode();
            if (StringUtils.isEmpty((String)securityCode)) {
                e.addPropertyError("securityCode", new RequiredError(new Object[0]));
            }
            if (!card.getCardType().isShowCardSecurityCode()) {
                String securityCodeConfirmation = form.getSecurityCodeConfirmation();
                if (StringUtils.isEmpty((String)securityCodeConfirmation)) {
                    e.addPropertyError("securityCodeConfirmation", new RequiredError(new Object[0]));
                }
                if (!ObjectUtils.equals((Object)securityCode, (Object)securityCodeConfirmation)) {
                    e.addGeneralError(new ValidationError("card.updateCard.cardCodesAreNotEqual", new Object[0]));
                }
            }
        }
        e.throwIfHasErrors();
    }
}

