/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.accounts.currencies;

import java.math.BigDecimal;
import java.util.Calendar;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.access.AdminSystemPermission;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.accounts.currencies.EditCurrencyForm;
import nl.strohalm.cyclos.entities.accounts.ARateParameters;
import nl.strohalm.cyclos.entities.accounts.Currency;
import nl.strohalm.cyclos.entities.accounts.DRateParameters;
import nl.strohalm.cyclos.entities.accounts.IRateParameters;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsChangeListener;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsEvent;
import nl.strohalm.cyclos.services.accounts.CurrencyService;
import nl.strohalm.cyclos.services.accounts.rates.RateService;
import nl.strohalm.cyclos.services.accounts.rates.WhatRate;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.conversion.IdConverter;
import org.apache.struts.action.ActionForward;

public class EditCurrencyAction
extends BaseFormAction
implements LocalSettingsChangeListener {
    private CurrencyService currencyService;
    private RateService rateService;
    private DataBinder<Currency> dataBinder;

    @Override
    public void onLocalSettingsUpdate(LocalSettingsEvent event) {
        this.dataBinder = null;
    }

    @Inject
    public void setCurrencyService(CurrencyService currencyService) {
        this.currencyService = currencyService;
    }

    @Inject
    public void setRateService(RateService rateService) {
        this.rateService = rateService;
    }

    @Override
    protected ActionForward handleDisplay(ActionContext context) throws Exception {
        Currency currency;
        HttpServletRequest request = context.getRequest();
        EditCurrencyForm form = (EditCurrencyForm)((Object)context.getForm());
        long id = form.getCurrencyId();
        boolean isInsert = id <= 0L;
        boolean editable = this.permissionService.hasPermission(AdminSystemPermission.CURRENCIES_MANAGE);
        if (isInsert) {
            currency = new Currency();
            editable = true;
        } else {
            currency = this.currencyService.load(id);
        }
        this.getDataBinder().writeAsString(form.getCurrency(), currency);
        form.setEnableARate(currency.isEnableARate());
        form.setEnableDRate(currency.isEnableDRate());
        form.setEnableIRate(currency.isEnableIRate());
        Calendar pendingRateInitProgression = this.rateService.checkPendingRateInitializations(currency);
        request.setAttribute("pendingRateInitProgression", (Object)pendingRateInitProgression);
        request.setAttribute("currency", (Object)currency);
        request.setAttribute("isInsert", (Object)isInsert);
        request.setAttribute("editable", (Object)editable);
        return new ActionForward("/pages/accounts/currencies/editCurrency.jsp");
    }

    @Override
    protected ActionForward handleSubmit(ActionContext context) throws Exception {
        EditCurrencyForm form = (EditCurrencyForm)((Object)context.getForm());
        Currency currency = this.getDataBinder().readFromString(form.getCurrency());
        boolean isInsert = currency.isTransient();
        WhatRate whatRate = new WhatRate();
        whatRate.setaRate(form.isEnableARate());
        whatRate.setdRate(form.isEnableDRate());
        whatRate.setiRate(form.isEnableIRate());
        currency = this.currencyService.save(currency, whatRate);
        if (isInsert) {
            context.sendMessage("currency.inserted", new Object[0]);
        } else {
            context.sendMessage("currency.modified", new Object[0]);
        }
        return ActionHelper.redirectWithParam(context.getRequest(), context.getSuccessForward(), "currencyId", currency.getId());
    }

    @Override
    protected void validateForm(ActionContext context) {
        EditCurrencyForm form = (EditCurrencyForm)((Object)context.getForm());
        Currency currency = this.getDataBinder().readFromString(form.getCurrency());
        WhatRate whatRate = new WhatRate();
        whatRate.setaRate(form.isEnableARate());
        whatRate.setdRate(form.isEnableDRate());
        whatRate.setiRate(false);
        this.currencyService.validate(currency, whatRate);
    }

    private DataBinder<Currency> getDataBinder() {
        if (this.dataBinder == null) {
            LocalSettings localSettings = this.settingsService.getLocalSettings();
            BeanBinder<Currency> binder = BeanBinder.instance(Currency.class);
            binder.registerBinder("id", PropertyBinder.instance(Long.class, "id", IdConverter.instance()));
            binder.registerBinder("name", PropertyBinder.instance(String.class, "name"));
            binder.registerBinder("symbol", PropertyBinder.instance(String.class, "symbol"));
            binder.registerBinder("pattern", PropertyBinder.instance(String.class, "pattern"));
            binder.registerBinder("description", PropertyBinder.instance(String.class, "description"));
            BeanBinder<ARateParameters> aRate = BeanBinder.instance(ARateParameters.class, "aRateParameters");
            aRate.registerBinder("id", PropertyBinder.instance(Long.class, "id", IdConverter.instance()));
            aRate.registerBinder("initValue", PropertyBinder.instance(BigDecimal.class, "initValue", localSettings.getNumberConverter()));
            aRate.registerBinder("initDate", PropertyBinder.instance(Calendar.class, "initDate", localSettings.getDateTimeConverter()));
            aRate.registerBinder("creationValue", PropertyBinder.instance(BigDecimal.class, "creationValue", localSettings.getNumberConverter()));
            binder.registerBinder("aRateParameters", aRate);
            BeanBinder<DRateParameters> dRate = BeanBinder.instance(DRateParameters.class, "dRateParameters");
            dRate.registerBinder("id", PropertyBinder.instance(Long.class, "id", IdConverter.instance()));
            dRate.registerBinder("interest", PropertyBinder.instance(BigDecimal.class, "interest", localSettings.getHighPrecisionConverter()));
            dRate.registerBinder("baseMalus", PropertyBinder.instance(BigDecimal.class, "baseMalus", localSettings.getHighPrecisionConverter()));
            dRate.registerBinder("minimalD", PropertyBinder.instance(BigDecimal.class, "minimalD", localSettings.getNumberConverter()));
            dRate.registerBinder("initValue", PropertyBinder.instance(BigDecimal.class, "initValue", localSettings.getNumberConverter()));
            dRate.registerBinder("initDate", PropertyBinder.instance(Calendar.class, "initDate", localSettings.getDateTimeConverter()));
            dRate.registerBinder("creationValue", PropertyBinder.instance(BigDecimal.class, "creationValue", localSettings.getNumberConverter()));
            binder.registerBinder("dRateParameters", dRate);
            BeanBinder<IRateParameters> iRate = BeanBinder.instance(IRateParameters.class, "iRateParameters");
            iRate.registerBinder("id", PropertyBinder.instance(Long.class, "id", IdConverter.instance()));
            binder.registerBinder("iRateParameters", iRate);
            this.dataBinder = binder;
        }
        return this.dataBinder;
    }
}

