/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.accounts.currencies;

import java.util.Calendar;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseAction;
import nl.strohalm.cyclos.controls.accounts.currencies.ManageCurrencyForm;
import nl.strohalm.cyclos.entities.accounts.Currency;
import nl.strohalm.cyclos.services.accounts.CurrencyService;
import nl.strohalm.cyclos.services.accounts.rates.RateService;
import org.apache.struts.action.ActionForward;

public class ManageCurrencyAction
extends BaseAction {
    private CurrencyService currencyService;
    private RateService rateService;

    @Inject
    public void setCurrencyService(CurrencyService currencyService) {
        this.currencyService = currencyService;
    }

    @Inject
    public void setRateService(RateService rateService) {
        this.rateService = rateService;
    }

    @Override
    protected ActionForward executeAction(ActionContext context) throws Exception {
        HttpServletRequest request = context.getRequest();
        ManageCurrencyForm manageForm = (ManageCurrencyForm)((Object)context.getForm());
        long id = manageForm.getCurrencyId();
        boolean isInsert = id <= 0L;
        Currency currency = isInsert ? new Currency() : this.currencyService.load(id);
        request.setAttribute("currency", (Object)currency);
        boolean ratesEnabled = this.rateService.isAnyRateEnabled(currency, null);
        request.setAttribute("ratesEnabled", (Object)ratesEnabled);
        Calendar pendingRateInitProgression = this.rateService.checkPendingRateInitializations(currency);
        request.setAttribute("pendingRateInit", (Object)pendingRateInitProgression);
        return context.getInputForward();
    }
}

