/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.accounts.currencies;

import java.util.Calendar;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.accounts.currencies.ReinitializeRatesForm;
import nl.strohalm.cyclos.entities.accounts.Currency;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsChangeListener;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsEvent;
import nl.strohalm.cyclos.services.accounts.CurrencyService;
import nl.strohalm.cyclos.services.accounts.rates.RateService;
import nl.strohalm.cyclos.services.accounts.rates.ReinitializeRatesDTO;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.conversion.IdConverter;
import org.apache.struts.action.ActionForward;

public class ReinitializeRatesAction
extends BaseFormAction
implements LocalSettingsChangeListener {
    private CurrencyService currencyService;
    private RateService rateService;
    private DataBinder<ReinitializeRatesDTO> dataBinder;

    @Override
    public void onLocalSettingsUpdate(LocalSettingsEvent event) {
        this.dataBinder = null;
    }

    @Inject
    public void setCurrencyService(CurrencyService currencyService) {
        this.currencyService = currencyService;
    }

    @Inject
    public void setRateService(RateService rateService) {
        this.rateService = rateService;
    }

    @Override
    protected ActionForward handleDisplay(ActionContext context) throws Exception {
        HttpServletRequest request = context.getRequest();
        ReinitializeRatesForm form = (ReinitializeRatesForm)((Object)context.getForm());
        long id = form.getCurrencyId();
        Currency currency = this.currencyService.load(id);
        request.setAttribute("enabledARate", (Object)currency.isEnableARate());
        request.setAttribute("enabledDRate", (Object)currency.isEnableDRate());
        request.setAttribute("enabledIRate", (Object)currency.isEnableIRate());
        request.setAttribute("enableDateA", (Object)this.rateService.getEnableDate(currency, RateService.RateType.A_RATE));
        request.setAttribute("enableDateD", (Object)this.rateService.getEnableDate(currency, RateService.RateType.D_RATE));
        request.setAttribute("enableDateI", (Object)this.rateService.getEnableDate(currency, RateService.RateType.I_RATE));
        request.setAttribute("currency", (Object)currency);
        ReinitializeRatesDTO dto = new ReinitializeRatesDTO();
        dto.setCurrencyId(id);
        dto.setMaintainPastSettings(true);
        this.getDataBinder().writeAsString(form.getReinitializeRatesDto(), dto);
        return new ActionForward("/pages/accounts/currencies/reinitializeRates.jsp");
    }

    @Override
    protected ActionForward handleSubmit(ActionContext context) throws Exception {
        ReinitializeRatesForm form = (ReinitializeRatesForm)((Object)context.getForm());
        ReinitializeRatesDTO reinitDto = this.getDataBinder().readFromString(form.getReinitializeRatesDto());
        reinitDto.setWhatRate(form.getWhatRate());
        reinitDto.setRequestURI(context.getRequest().getRequestURI());
        this.rateService.reinitializeRate(reinitDto);
        return ActionHelper.redirectWithParam(context.getRequest(), context.getSuccessForward(), "currencyId", reinitDto.getCurrencyId());
    }

    @Override
    protected void validateForm(ActionContext context) {
        ReinitializeRatesForm form = (ReinitializeRatesForm)((Object)context.getForm());
        ReinitializeRatesDTO reinitDto = this.getDataBinder().readFromString(form.getReinitializeRatesDto());
        reinitDto.setWhatRate(form.getWhatRate());
        this.rateService.validate(reinitDto);
    }

    private DataBinder<ReinitializeRatesDTO> getDataBinder() {
        if (this.dataBinder == null) {
            LocalSettings localSettings = this.settingsService.getLocalSettings();
            BeanBinder<ReinitializeRatesDTO> binder = BeanBinder.instance(ReinitializeRatesDTO.class);
            binder.registerBinder("currencyId", PropertyBinder.instance(Long.class, "currencyId", IdConverter.instance()));
            binder.registerBinder("reinitSince", PropertyBinder.instance(Calendar.class, "reinitSince", localSettings.getDateConverter()));
            binder.registerBinder("maintainPastSettings", PropertyBinder.instance(Boolean.TYPE, "maintainPastSettings"));
            this.dataBinder = binder;
        }
        return this.dataBinder;
    }
}

