/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.accounts.details;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.EnumSet;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.access.AdminSystemPermission;
import nl.strohalm.cyclos.access.BrokerPermission;
import nl.strohalm.cyclos.access.MemberPermission;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseQueryAction;
import nl.strohalm.cyclos.controls.accounts.details.AccountHistoryForm;
import nl.strohalm.cyclos.entities.EntityReference;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.Account;
import nl.strohalm.cyclos.entities.accounts.AccountOwner;
import nl.strohalm.cyclos.entities.accounts.AccountStatus;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.accounts.MemberAccount;
import nl.strohalm.cyclos.entities.accounts.SystemAccountOwner;
import nl.strohalm.cyclos.entities.accounts.SystemAccountType;
import nl.strohalm.cyclos.entities.accounts.transactions.Payment;
import nl.strohalm.cyclos.entities.accounts.transactions.PaymentFilter;
import nl.strohalm.cyclos.entities.accounts.transactions.PaymentFilterQuery;
import nl.strohalm.cyclos.entities.accounts.transactions.Transfer;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferQuery;
import nl.strohalm.cyclos.entities.customization.fields.PaymentCustomField;
import nl.strohalm.cyclos.entities.customization.fields.PaymentCustomFieldValue;
import nl.strohalm.cyclos.entities.groups.AdminGroup;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.GroupFilter;
import nl.strohalm.cyclos.entities.groups.GroupFilterQuery;
import nl.strohalm.cyclos.entities.groups.GroupQuery;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.OperatorQuery;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsEvent;
import nl.strohalm.cyclos.services.accounts.AccountDTO;
import nl.strohalm.cyclos.services.accounts.AccountService;
import nl.strohalm.cyclos.services.accounts.AccountTypeService;
import nl.strohalm.cyclos.services.accounts.GetTransactionsDTO;
import nl.strohalm.cyclos.services.customization.PaymentCustomFieldService;
import nl.strohalm.cyclos.services.elements.ElementService;
import nl.strohalm.cyclos.services.groups.GroupFilterService;
import nl.strohalm.cyclos.services.permissions.PermissionService;
import nl.strohalm.cyclos.services.transactions.PaymentService;
import nl.strohalm.cyclos.services.transfertypes.PaymentFilterService;
import nl.strohalm.cyclos.utils.CustomFieldHelper;
import nl.strohalm.cyclos.utils.Period;
import nl.strohalm.cyclos.utils.PropertyHelper;
import nl.strohalm.cyclos.utils.RequestHelper;
import nl.strohalm.cyclos.utils.TimePeriod;
import nl.strohalm.cyclos.utils.TransformedIteratorList;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.BeanCollectionBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.DataBinderHelper;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.binding.SimpleCollectionBinder;
import nl.strohalm.cyclos.utils.conversion.AccountOwnerConverter;
import nl.strohalm.cyclos.utils.conversion.ReferenceConverter;
import nl.strohalm.cyclos.utils.conversion.Transformer;
import nl.strohalm.cyclos.utils.query.QueryParameters;

public class AccountHistoryAction
extends BaseQueryAction {
    protected AccountService accountService;
    protected PaymentFilterService paymentFilterService;
    protected PaymentCustomFieldService paymentCustomFieldService;
    private AccountTypeService accountTypeService;
    private PaymentService paymentService;
    private GroupFilterService groupFilterService;
    private DataBinder<TransferQuery> dataBinder;
    private CustomFieldHelper customFieldHelper;

    public static DataBinder<TransferQuery> transferQueryDataBinder(LocalSettings localSettings) {
        BeanBinder<PaymentCustomFieldValue> customValueBinder = BeanBinder.instance(PaymentCustomFieldValue.class);
        customValueBinder.registerBinder("field", PropertyBinder.instance(PaymentCustomField.class, "field"));
        customValueBinder.registerBinder("value", PropertyBinder.instance(String.class, "value"));
        BeanBinder<TransferQuery> binder = BeanBinder.instance(TransferQuery.class);
        binder.registerBinder("owner", PropertyBinder.instance(AccountOwner.class, "owner", AccountOwnerConverter.instance()));
        binder.registerBinder("status", PropertyBinder.instance(Payment.Status.class, "status"));
        binder.registerBinder("type", PropertyBinder.instance(AccountType.class, "type", ReferenceConverter.instance(AccountType.class)));
        binder.registerBinder("period", DataBinderHelper.rawPeriodBinder(localSettings, "period"));
        binder.registerBinder("paymentFilter", PropertyBinder.instance(PaymentFilter.class, "paymentFilter", ReferenceConverter.instance(PaymentFilter.class)));
        binder.registerBinder("description", PropertyBinder.instance(String.class, "description"));
        binder.registerBinder("transactionNumber", PropertyBinder.instance(String.class, "transactionNumber"));
        binder.registerBinder("member", PropertyBinder.instance(Member.class, "member", ReferenceConverter.instance(Member.class)));
        binder.registerBinder("by", PropertyBinder.instance(Element.class, "by", ReferenceConverter.instance(Element.class)));
        binder.registerBinder("conciliated", PropertyBinder.instance(Boolean.class, "conciliated"));
        binder.registerBinder("groups", SimpleCollectionBinder.instance(MemberGroup.class, "groups"));
        binder.registerBinder("groupFilters", SimpleCollectionBinder.instance(GroupFilter.class, "groupFilters"));
        binder.registerBinder("customValues", BeanCollectionBinder.instance(customValueBinder, "customValues"));
        binder.registerBinder("pageParameters", DataBinderHelper.pageBinder());
        return binder;
    }

    public DataBinder<TransferQuery> getDataBinder() {
        if (this.dataBinder == null) {
            LocalSettings localSettings = this.settingsService.getLocalSettings();
            this.dataBinder = AccountHistoryAction.transferQueryDataBinder(localSettings);
        }
        return this.dataBinder;
    }

    @Override
    public void onLocalSettingsUpdate(LocalSettingsEvent event) {
        super.onLocalSettingsUpdate(event);
        this.dataBinder = null;
    }

    @Inject
    public void setAccountService(AccountService accountService) {
        this.accountService = accountService;
    }

    @Inject
    public void setAccountTypeService(AccountTypeService accountTypeService) {
        this.accountTypeService = accountTypeService;
    }

    @Inject
    public void setCustomFieldHelper(CustomFieldHelper customFieldHelper) {
        this.customFieldHelper = customFieldHelper;
    }

    @Inject
    public void setGroupFilterService(GroupFilterService groupFilterService) {
        this.groupFilterService = groupFilterService;
    }

    @Inject
    public void setPaymentCustomFieldService(PaymentCustomFieldService paymentCustomFieldService) {
        this.paymentCustomFieldService = paymentCustomFieldService;
    }

    @Inject
    public void setPaymentFilterService(PaymentFilterService paymentFilterService) {
        this.paymentFilterService = paymentFilterService;
    }

    @Inject
    public void setPaymentService(PaymentService paymentService) {
        this.paymentService = paymentService;
    }

    @Override
    protected void executeQuery(ActionContext context, QueryParameters queryParameters) {
        HttpServletRequest request = context.getRequest();
        TransferQuery query = (TransferQuery)queryParameters;
        Account account = (Account)request.getAttribute("account");
        List<Transfer> transfers = this.paymentService.search(query);
        request.setAttribute("transfers", transfers);
        request.setAttribute("accountHistory", Entry.build(this.permissionService, this.elementService, account, transfers, this.fetchMember()));
    }

    protected boolean fetchMember() {
        return true;
    }

    @Override
    protected QueryParameters prepareForm(ActionContext context) {
        Member loggedMember;
        AccountOwner owner;
        HttpServletRequest request = context.getRequest();
        AccountHistoryForm form = (AccountHistoryForm)((Object)context.getForm());
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        boolean firstTime = false;
        if (RequestHelper.isGet(request)) {
            form.setQuery("owner", form.getMemberId());
            form.setQuery("type", form.getTypeId());
            firstTime = true;
        }
        TransferQuery query = this.getDataBinder().readFromString(form.getQuery());
        query.fetch(Payment.Relationships.CUSTOM_VALUES, Payment.Relationships.FROM, Payment.Relationships.TO, Payment.Relationships.TYPE);
        query.setReverseOrder(true);
        AccountType type = this.accountTypeService.load(query.getType().getId());
        if (query.getStatus() == null) {
            query.setStatus(Payment.Status.PROCESSED);
            form.setQuery("status", query.getStatus().name());
        }
        if (firstTime && type instanceof SystemAccountType) {
            Period lastMonthPeriod = TimePeriod.ONE_MONTH.previousPeriod(Calendar.getInstance());
            query.setPeriod(Period.begginingAt(lastMonthPeriod.getBegin()));
            String formattedDate = localSettings.getDateConverter().toString(lastMonthPeriod.getBegin());
            PropertyHelper.set(form.getQuery("period"), "begin", formattedDate);
        }
        if ((owner = query.getOwner()) == null) {
            owner = SystemAccountOwner.instance();
        } else if (owner instanceof EntityReference) {
            owner = (AccountOwner)this.elementService.load(((Member)owner).getId(), new Relationship[0]);
        }
        boolean showStatus = false;
        if (owner instanceof SystemAccountOwner) {
            showStatus = this.permissionService.hasPermission(AdminSystemPermission.ACCOUNTS_AUTHORIZED_INFORMATION);
        } else if (context.isAdmin()) {
            showStatus = this.permissionService.hasPermission(AdminMemberPermission.ACCOUNTS_AUTHORIZED_INFORMATION);
        } else if (context.getAccountOwner().equals(owner)) {
            showStatus = this.permissionService.hasPermission(MemberPermission.ACCOUNT_AUTHORIZED_INFORMATION);
        } else if (owner instanceof Member && context.isBrokerOf((Member)owner)) {
            showStatus = this.permissionService.hasPermission(BrokerPermission.ACCOUNTS_AUTHORIZED_INFORMATION);
        }
        if (showStatus) {
            request.setAttribute("paymentStatus", EnumSet.of(Payment.Status.PROCESSED, Payment.Status.PENDING, Payment.Status.DENIED, Payment.Status.CANCELED));
        }
        Account account = this.accountService.getAccount(new AccountDTO(owner, type), new Relationship[0]);
        if (query.getMember() instanceof EntityReference) {
            query.setMember((Member)this.elementService.load(query.getMember().getId(), Element.Relationships.USER));
        }
        if ((loggedMember = context.getMember()) != null && form.isAdvanced()) {
            OperatorQuery oq = new OperatorQuery();
            oq.setMember(loggedMember);
            List<? extends Element> operators = this.elementService.search(oq);
            request.setAttribute("operators", operators);
        }
        if (type instanceof SystemAccountType) {
            AdminGroup adminGroup = (AdminGroup)context.getGroup();
            GroupQuery groups = new GroupQuery();
            groups.setManagedBy(adminGroup);
            groups.setNatures(Group.Nature.MEMBER, Group.Nature.BROKER);
            groups.setStatus(Group.Status.NORMAL);
            request.setAttribute("memberGroups", this.groupService.search(groups));
            GroupFilterQuery groupFilters = new GroupFilterQuery();
            groupFilters.setAdminGroup(adminGroup);
            request.setAttribute("groupFilters", this.groupFilterService.search(groupFilters));
        }
        AccountStatus status = this.accountService.getRatedStatus(account, null);
        BigDecimal min = this.paymentService.getMinimumPayment();
        GetTransactionsDTO params = new GetTransactionsDTO(query.getOwner(), query.getType());
        BigDecimal creditLimit = this.accountService.getCreditLimit(params);
        if (creditLimit != null && creditLimit.abs().compareTo(min) == 1) {
            request.setAttribute("creditLimit", (Object)creditLimit.negate());
        }
        PaymentFilterQuery pfQuery = new PaymentFilterQuery();
        pfQuery.setAccountType(query.getType());
        pfQuery.setContext(PaymentFilterQuery.Context.ACCOUNT_HISTORY);
        pfQuery.setElement((Element)(owner instanceof SystemAccountOwner ? context.getElement() : (Member)owner));
        List<PaymentFilter> paymentFilters = this.paymentFilterService.search(pfQuery);
        request.setAttribute("owner", (Object)(owner instanceof SystemAccountOwner ? null : owner));
        request.setAttribute("type", (Object)type);
        request.setAttribute("paymentFilters", paymentFilters);
        request.setAttribute("myAccount", (Object)context.getAccountOwner().equals(owner));
        request.setAttribute("status", (Object)status);
        request.setAttribute("unitsPattern", (Object)type.getCurrency().getPattern());
        request.setAttribute("account", (Object)account);
        if (type instanceof SystemAccountType) {
            SystemAccountType systemType = (SystemAccountType)type;
            request.setAttribute("showConciliated", (Object)(!systemType.getExternalAccounts().isEmpty() ? 1 : 0));
        } else {
            request.setAttribute("showConciliated", (Object)Boolean.FALSE);
        }
        List<PaymentCustomField> customFieldsForSearch = this.paymentCustomFieldService.listForSearch(account, false);
        List<PaymentCustomField> customFieldsForList = this.paymentCustomFieldService.listForList(account, false);
        request.setAttribute("customFieldsForSearch", this.customFieldHelper.buildEntries(customFieldsForSearch, query.getCustomValues()));
        request.setAttribute("customFieldsForList", customFieldsForList);
        String backTo = null;
        if (type instanceof SystemAccountType) {
            if (!form.isSingleAccount()) {
                backTo = context.getPathPrefix() + "/accountOverview";
            }
        } else {
            Member member = (Member)owner;
            backTo = form.isSingleAccount() ? context.getPathPrefix() + "/profile?memberId=" + member.getId() : context.getPathPrefix() + "/accountOverview?memberId=" + member.getId();
        }
        request.setAttribute("backTo", backTo);
        return query;
    }

    @Override
    protected boolean willExecuteQuery(ActionContext context, QueryParameters queryParameters) throws Exception {
        return true;
    }

    private static class TransformTransferInEntry
    implements Transformer<Transfer, Entry> {
        private Account account;
        private boolean fetchMember;

        private TransformTransferInEntry(PermissionService permissionService, ElementService elementService, Account account, boolean fetchMember) {
            this.account = account;
            this.fetchMember = fetchMember;
        }

        @Override
        public Entry transform(Transfer transfer) {
            Account from = transfer.getActualFrom();
            Account to = transfer.getActualTo();
            Account relatedAccount = this.account.equals(from) ? to : from;
            Long relatedMemberId = null;
            if (this.fetchMember && relatedAccount instanceof MemberAccount) {
                MemberAccount ma = (MemberAccount)relatedAccount;
                relatedMemberId = ma.getMember().getId();
            }
            return new Entry(this.account, transfer, relatedAccount, relatedMemberId);
        }
    }

    public static class Entry
    implements Serializable {
        private static final long serialVersionUID = -4696245469424024391L;
        private final Account account;
        private final Account related;
        private final Long relatedMemberId;
        private final Transfer transfer;
        private final int signal;

        public static List<Entry> build(PermissionService permissionService, ElementService elementService, Account account, List<Transfer> transfers, boolean fetchMember) {
            TransformTransferInEntry transformTransferInEntry = new TransformTransferInEntry(permissionService, elementService, account, fetchMember);
            return new TransformedIteratorList<Transfer, Entry>(transformTransferInEntry, transfers);
        }

        private Entry(Account account, Transfer transfer, Account relatedAccount, Long relatedMemberId) {
            this.transfer = transfer;
            this.account = account;
            this.related = relatedAccount;
            this.relatedMemberId = relatedMemberId;
            this.signal = account.equals(transfer.getActualFrom()) ? -1 : 1;
        }

        public Account getAccount() {
            return this.account;
        }

        public BigDecimal getAmount() {
            BigDecimal amount = this.transfer.getActualAmount();
            return this.signal < 0 ? amount.negate() : amount;
        }

        public Account getRelated() {
            return this.related;
        }

        public Long getRelatedMemberId() {
            return this.relatedMemberId;
        }

        public int getSignal() {
            return this.signal;
        }

        public Transfer getTransfer() {
            return this.transfer;
        }

        public boolean isCredit() {
            return this.signal > 0;
        }

        public boolean isDebit() {
            return this.signal < 0;
        }
    }
}

