/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.accounts.details;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseAction;
import nl.strohalm.cyclos.controls.accounts.details.AccountOverviewForm;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.accounts.Account;
import nl.strohalm.cyclos.entities.accounts.AccountOwner;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.services.accounts.AccountDateDTO;
import nl.strohalm.cyclos.services.accounts.AccountService;
import nl.strohalm.cyclos.services.accounts.AccountTypeService;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.struts.action.ActionForward;

public class AccountOverviewAction
extends BaseAction {
    private AccountService accountService;
    private AccountTypeService accountTypeService;

    public AccountService getAccountService() {
        return this.accountService;
    }

    public AccountTypeService getAccountTypeService() {
        return this.accountTypeService;
    }

    @Inject
    public void setAccountService(AccountService accountService) {
        this.accountService = accountService;
    }

    @Inject
    public void setAccountTypeService(AccountTypeService accountTypeService) {
        this.accountTypeService = accountTypeService;
    }

    @Override
    protected ActionForward executeAction(ActionContext context) throws Exception {
        List<? extends Account> accounts;
        AccountOwner owner;
        AccountOverviewForm form = (AccountOverviewForm)((Object)context.getForm());
        HttpServletRequest request = context.getRequest();
        long memberId = form.getMemberId();
        Member member = null;
        boolean myAccounts = false;
        boolean byBroker = false;
        Object loggedElement = context.getElement();
        if (memberId <= 0L || memberId == ((Entity)loggedElement).getId()) {
            owner = context.getAccountOwner();
            myAccounts = true;
            if (context.isMember()) {
                member = (Member)context.getElement();
            }
        } else {
            Object element = this.elementService.load(memberId, Element.Relationships.USER);
            if (!(element instanceof Member)) {
                throw new ValidationException();
            }
            member = (Member)element;
            owner = member;
            if (context.isMember()) {
                if (!context.isBrokerOf(member)) {
                    throw new ValidationException();
                }
                byBroker = true;
            }
        }
        if ((accounts = this.accountService.getAccounts(owner, RelationshipHelper.nested(Account.Relationships.TYPE, AccountType.Relationships.CURRENCY))).isEmpty()) {
            return context.sendError("accountOverview.error.noAccounts", new Object[0]);
        }
        if (accounts.size() == 1) {
            context.getNavigation().removeCurrent();
            Account account = accounts.get(0);
            AccountType accountType = account.getType();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("memberId", form.getMemberId());
            params.put("typeId", accountType.getId());
            params.put("singleAccount", true);
            params.put("fromQuickAccess", request.getParameter("fromQuickAccess"));
            return ActionHelper.redirectWithParams(context.getRequest(), context.findForward("accountDetails"), params);
        }
        request.setAttribute("member", (Object)member);
        request.setAttribute("myAccounts", (Object)myAccounts);
        request.setAttribute("byBroker", (Object)byBroker);
        request.setAttribute("overview", this.resolveAccountOverview(accounts));
        return context.getInputForward();
    }

    private Map<Account, BigDecimal> resolveAccountOverview(List<? extends Account> accounts) {
        LinkedHashMap<Account, BigDecimal> overview = new LinkedHashMap<Account, BigDecimal>();
        for (Account account : accounts) {
            try {
                BigDecimal balance = this.accountService.getBalance(new AccountDateDTO(account));
                overview.put(account, balance);
            }
            catch (EntityNotFoundException e) {}
        }
        return overview;
    }
}

