/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.accounts.details;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.BaseQueryAction;
import nl.strohalm.cyclos.entities.accounts.MemberAccountType;
import nl.strohalm.cyclos.entities.accounts.transactions.AuthorizationLevel;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferTypeQuery;
import nl.strohalm.cyclos.entities.groups.AdminGroup;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.Administrator;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.Operator;
import nl.strohalm.cyclos.services.transactions.TransferAuthorizationService;
import nl.strohalm.cyclos.services.transfertypes.TransferTypeService;
import nl.strohalm.cyclos.utils.RelationshipHelper;

public abstract class BaseTransferAuthorizationSearchAction
extends BaseQueryAction {
    protected TransferAuthorizationService transferAuthorizationService;
    protected TransferTypeService transferTypeService;

    @Inject
    public void setTransferAuthorizationService(TransferAuthorizationService transferAuthorizationService) {
        this.transferAuthorizationService = transferAuthorizationService;
    }

    @Inject
    public void setTransferTypeService(TransferTypeService transferTypeService) {
        this.transferTypeService = transferTypeService;
    }

    protected List<TransferType> resolveTransferTypes(Element element) {
        EnumSet<AuthorizationLevel.Authorizer> authorizers;
        element = this.elementService.load(element.getId(), Element.Relationships.GROUP);
        TransferTypeQuery ttQuery = new TransferTypeQuery();
        ttQuery.setAuthorizable(true);
        AdminGroup authorizerGroup = null;
        if (element instanceof Administrator) {
            authorizers = EnumSet.of(AuthorizationLevel.Authorizer.BROKER, AuthorizationLevel.Authorizer.ADMIN);
            authorizerGroup = (AdminGroup)element.getGroup();
        } else {
            Member member = null;
            if (element instanceof Operator) {
                Operator operator = (Operator)element;
                member = (Member)this.elementService.load(operator.getMember().getId(), RelationshipHelper.nested(Element.Relationships.GROUP, MemberGroup.Relationships.ACCOUNT_SETTINGS));
            } else {
                member = (Member)this.elementService.load(((Member)element).getId(), RelationshipHelper.nested(Element.Relationships.GROUP, MemberGroup.Relationships.ACCOUNT_SETTINGS));
            }
            ttQuery.setFromOrToAccountTypes(new ArrayList<MemberAccountType>(member.getMemberGroup().getAccountTypes()));
            authorizers = EnumSet.of(AuthorizationLevel.Authorizer.RECEIVER);
            if (member.getMemberGroup().isBroker()) {
                authorizers.add(AuthorizationLevel.Authorizer.BROKER);
            }
        }
        ttQuery.setAuthorizers(authorizers);
        ttQuery.setAuthorizerGroup(authorizerGroup);
        ttQuery.fetch(TransferType.Relationships.AUTHORIZATION_LEVELS);
        List<TransferType> transferTypes = this.transferTypeService.search(ttQuery);
        return transferTypes;
    }
}

