/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.accounts.details;

import java.util.List;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseCsvAction;
import nl.strohalm.cyclos.controls.accounts.details.AccountHistoryAction;
import nl.strohalm.cyclos.controls.accounts.details.AccountHistoryForm;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.access.User;
import nl.strohalm.cyclos.entities.accounts.Account;
import nl.strohalm.cyclos.entities.accounts.MemberAccount;
import nl.strohalm.cyclos.entities.accounts.transactions.Payment;
import nl.strohalm.cyclos.entities.accounts.transactions.Transfer;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferQuery;
import nl.strohalm.cyclos.entities.customization.fields.PaymentCustomField;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsEvent;
import nl.strohalm.cyclos.services.accounts.AccountDTO;
import nl.strohalm.cyclos.services.accounts.AccountService;
import nl.strohalm.cyclos.services.customization.PaymentCustomFieldService;
import nl.strohalm.cyclos.services.transactions.PaymentService;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.conversion.Converter;
import nl.strohalm.cyclos.utils.conversion.CustomFieldConverter;
import nl.strohalm.cyclos.utils.csv.CSVWriter;
import nl.strohalm.cyclos.utils.query.QueryParameters;

public class ExportTransactionsToCsvAction
extends BaseCsvAction {
    private DataBinder<TransferQuery> dataBinder;
    private PaymentService paymentService;
    private AccountService accountService;
    private PaymentCustomFieldService paymentCustomFieldService;

    public DataBinder<TransferQuery> getDataBinder() {
        if (this.dataBinder == null) {
            this.dataBinder = AccountHistoryAction.transferQueryDataBinder(this.settingsService.getLocalSettings());
        }
        return this.dataBinder;
    }

    @Override
    public void onLocalSettingsUpdate(LocalSettingsEvent event) {
        super.onLocalSettingsUpdate(event);
        this.dataBinder = null;
    }

    @Inject
    public void setAccountService(AccountService accountService) {
        this.accountService = accountService;
    }

    @Inject
    public void setPaymentCustomFieldService(PaymentCustomFieldService paymentCustomFieldService) {
        this.paymentCustomFieldService = paymentCustomFieldService;
    }

    @Inject
    public void setPaymentService(PaymentService paymentService) {
        this.paymentService = paymentService;
    }

    protected List<?> executeQuery(ActionContext context) {
        AccountHistoryForm form = (AccountHistoryForm)((Object)context.getForm());
        TransferQuery query = this.getDataBinder().readFromString(form.getQuery());
        Account account = this.getAccount(query);
        query.fetch(Payment.Relationships.FROM, Payment.Relationships.TO, Payment.Relationships.TYPE);
        query.setResultType(QueryParameters.ResultType.ITERATOR);
        List<Transfer> transfers = this.paymentService.search(query);
        return AccountHistoryAction.Entry.build(this.permissionService, this.elementService, account, transfers, false);
    }

    @Override
    protected String fileName(ActionContext context) {
        Object loggedUser = context.getUser();
        return "transactions_" + ((User)loggedUser).getUsername() + ".csv";
    }

    protected CSVWriter<Transfer> resolveCSVWriter(ActionContext context) {
        AccountHistoryForm form = (AccountHistoryForm)((Object)context.getForm());
        TransferQuery query = this.getDataBinder().readFromString(form.getQuery());
        Account account = this.getAccount(query);
        LocalSettings settings = this.settingsService.getLocalSettings();
        CSVWriter<Transfer> csv = CSVWriter.instance(Transfer.class, settings);
        csv.addColumn(context.message("transfer.date", new Object[0]), "transfer.actualDate", settings.getDateTimeConverter());
        csv.addColumn(context.message("transfer.type", new Object[0]), "transfer.type.name");
        csv.addColumn(context.message("transfer.amount", new Object[0]), "amount", settings.getNumberConverter());
        csv.addColumn(context.message("transfer.fromOrTo", new Object[0]), "related.ownerName");
        csv.addColumn(context.message("transfer.fromOrTo", new Object[0]) + " - " + context.message("member.name", new Object[0]), "related", new Converter<Account>(){
            private static final long serialVersionUID = 1L;

            @Override
            public String toString(Account account) {
                if (account instanceof MemberAccount) {
                    return ((MemberAccount)account).getMember().getName();
                }
                return null;
            }

            @Override
            public Account valueOf(String string) {
                return null;
            }
        });
        List<PaymentCustomField> customFields = this.paymentCustomFieldService.listForList(account, false);
        for (PaymentCustomField field : customFields) {
            csv.addColumn(field.getName(), "transfer.customValues", new CustomFieldConverter(field, this.elementService, settings));
        }
        csv.addColumn(context.message("transfer.description", new Object[0]), "transfer.description");
        if (settings.getTransactionNumber() != null && settings.getTransactionNumber().isValid()) {
            csv.addColumn(context.message("transfer.transactionNumber", new Object[0]), "transfer.transactionNumber");
        }
        return csv;
    }

    @Override
    protected boolean shouldLimit() {
        return false;
    }

    private Account getAccount(TransferQuery query) {
        return this.accountService.getAccount(new AccountDTO(query.getOwner(), query.getType()), new Relationship[0]);
    }
}

