/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.accounts.details;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.accounts.details.AccountHistoryAction;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.AccountStatus;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferQuery;
import nl.strohalm.cyclos.entities.customization.fields.CustomField;
import nl.strohalm.cyclos.entities.customization.fields.CustomFieldPossibleValue;
import nl.strohalm.cyclos.entities.customization.fields.CustomFieldValue;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.services.accounts.AccountDateDTO;
import nl.strohalm.cyclos.services.accounts.GetTransactionsDTO;
import nl.strohalm.cyclos.utils.CustomFieldHelper;
import nl.strohalm.cyclos.utils.DateHelper;
import nl.strohalm.cyclos.utils.EntityHelper;
import nl.strohalm.cyclos.utils.Period;
import nl.strohalm.cyclos.utils.conversion.IdConverter;
import nl.strohalm.cyclos.utils.query.QueryParameters;
import org.apache.commons.lang.StringUtils;

public class PrintAccountHistoryAction
extends AccountHistoryAction {
    @Override
    protected Integer pageSize(ActionContext context) {
        return null;
    }

    @Override
    protected QueryParameters prepareForm(ActionContext context) {
        TransferQuery query = (TransferQuery)super.prepareForm(context);
        HttpServletRequest request = context.getRequest();
        if (query.getPaymentFilter() != null) {
            query.setPaymentFilter(this.paymentFilterService.load(query.getPaymentFilter().getId(), new Relationship[0]));
        }
        if (query.getMember() != null) {
            query.setMember((Member)this.elementService.load(query.getMember().getId(), new Relationship[0]));
        }
        if (query.getBy() != null) {
            query.setBy((Element)this.elementService.load(query.getBy().getId(), new Relationship[0]));
        }
        Period period = query.getPeriod();
        GetTransactionsDTO dto = new GetTransactionsDTO(query.getOwner(), query.getType(), period);
        dto.setRelatedToMember(query.getMember());
        dto.setPaymentFilter(query.getPaymentFilter());
        dto.setBy(query.getBy());
        AccountStatus status = (AccountStatus)request.getAttribute("status");
        if (period != null && period.getBegin() != null) {
            BigDecimal initialBalance = this.accountService.getBalance(new AccountDateDTO(status.getAccount(), period.getBegin()));
            request.setAttribute("initialBalance", (Object)initialBalance);
        }
        if (period != null && period.getEnd() != null) {
            Calendar end = DateHelper.getDayEnd(period.getEnd());
            BigDecimal finalBalance = this.accountService.getBalance(new AccountDateDTO(status.getAccount(), end));
            request.setAttribute("finalBalance", (Object)finalBalance);
        }
        LinkedHashMap<String, String> customValueFilters = new LinkedHashMap<String, String>();
        Collection entries = (Collection)request.getAttribute("customFieldsForSearch");
        for (CustomFieldHelper.Entry entry : entries) {
            CustomField field = entry.getField();
            CustomFieldValue fieldValue = entry.getValue();
            if (fieldValue == null) continue;
            String value = null;
            if (field.getType() == CustomField.Type.ENUMERATED) {
                String[] parts = StringUtils.split((String)fieldValue.getValue(), (String)",");
                if (parts == null) continue;
                List<CustomFieldPossibleValue> possibleValues = this.paymentCustomFieldService.loadPossibleValues(Arrays.asList(EntityHelper.toIds(parts)));
                boolean first = true;
                StringBuilder sb = new StringBuilder();
                for (CustomFieldPossibleValue possibleValue : possibleValues) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(", ");
                    }
                    sb.append(possibleValue.getValue());
                }
                value = sb.toString();
            } else if (field.getType() == CustomField.Type.MEMBER) {
                Object element;
                Long memberId = null;
                memberId = fieldValue.getMemberValue() != null ? fieldValue.getMemberValue().getId() : IdConverter.instance().valueOf(fieldValue.getValue());
                if (memberId != null && (element = this.elementService.load(memberId, new Relationship[0])) instanceof Member) {
                    LocalSettings.MemberResultDisplay memberResultDisplay = this.settingsService.getLocalSettings().getMemberResultDisplay();
                    value = memberResultDisplay == LocalSettings.MemberResultDisplay.NAME ? ((Element)element).getName() : ((Element)element).getUsername();
                }
            } else {
                value = fieldValue.getValue();
            }
            customValueFilters.put(field.getName(), value);
        }
        request.setAttribute("customValueFilters", customValueFilters);
        return query;
    }
}

