/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.accounts.details;

import java.util.List;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseReceiptPrintAjaxAction;
import nl.strohalm.cyclos.controls.accounts.details.ViewScheduledPaymentAction;
import nl.strohalm.cyclos.controls.payments.scheduled.ScheduledPaymentForm;
import nl.strohalm.cyclos.entities.accounts.Account;
import nl.strohalm.cyclos.entities.accounts.MemberAccount;
import nl.strohalm.cyclos.entities.accounts.SystemAccount;
import nl.strohalm.cyclos.entities.accounts.transactions.ScheduledPayment;
import nl.strohalm.cyclos.entities.accounts.transactions.Transfer;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.printsettings.ReceiptPrinterSettings;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.services.transactions.ScheduledPaymentService;
import nl.strohalm.cyclos.utils.conversion.CalendarConverter;
import nl.strohalm.cyclos.utils.conversion.UnitsConverter;
import org.apache.commons.lang.StringUtils;

public class ScheduledPaymentReceiptAjaxAction
extends BaseReceiptPrintAjaxAction {
    protected ScheduledPaymentService scheduledPaymentService;

    @Inject
    public void setScheduledPaymentService(ScheduledPaymentService scheduledPaymentService) {
        this.scheduledPaymentService = scheduledPaymentService;
    }

    @Override
    protected String resolveText(ActionContext context, ReceiptPrinterSettings receiptPrinterSettings) {
        ScheduledPaymentForm form = (ScheduledPaymentForm)((Object)context.getForm());
        long paymentId = form.getPaymentId();
        ScheduledPayment scheduledPayment = this.scheduledPaymentService.load(paymentId, ViewScheduledPaymentAction.FETCH);
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        CalendarConverter dateTimeConverter = localSettings.getDateTimeConverter();
        CalendarConverter dateConverter = localSettings.getDateConverter();
        UnitsConverter unitsConverter = localSettings.getUnitsConverter(scheduledPayment.getFrom().getType().getCurrency().getPattern());
        int installmentCount = scheduledPayment.getTransfers().size();
        boolean singleInstallment = installmentCount == 1;
        StringBuilder out = new StringBuilder();
        out.append(context.message("receipt.transfer.header", localSettings.getApplicationName())).append('\n');
        out.append(context.message("receipt.transfer.textBefore", new Object[0])).append('\n');
        out.append(context.message("receipt.transfer.from", this.ownerString(scheduledPayment.getFrom()))).append('\n');
        out.append(context.message("receipt.transfer.to", this.ownerString(scheduledPayment.getTo()))).append('\n');
        out.append(context.message("receipt.transfer.date", dateTimeConverter.toString(scheduledPayment.getDate()))).append('\n');
        out.append(context.message("receipt.transfer.amount", unitsConverter.toString(scheduledPayment.getAmount()))).append('\n');
        if (singleInstallment) {
            out.append(context.message("receipt.transfer.scheduledFor", dateConverter.toString(scheduledPayment.getTransfers().get(0).getDate()))).append('\n');
        }
        if (!singleInstallment) {
            List<Transfer> installments = scheduledPayment.getTransfers();
            out.append(context.message("receipt.transfer.installments", installments.size())).append('\n');
            int maxDigits = String.valueOf(installments.size()).length();
            for (int i = 0; i < installmentCount; ++i) {
                Transfer installment = installments.get(i);
                String index = StringUtils.leftPad((String)String.valueOf(i + 1), (int)maxDigits, (char)'0');
                String date = dateConverter.toString(installment.getDate());
                String amount = unitsConverter.toString(installment.getAmount());
                out.append(context.message("receipt.transfer.installment", index, date, amount)).append('\n');
            }
        }
        if (StringUtils.isNotEmpty((String)receiptPrinterSettings.getPaymentAdditionalMessage())) {
            out.append('\n').append(receiptPrinterSettings.getPaymentAdditionalMessage()).append('\n');
        }
        out.append(context.message("receipt.transfer.textAfter", new Object[0]));
        return out.toString();
    }

    private String ownerString(Account account) {
        if (account instanceof SystemAccount) {
            return account.getOwnerName();
        }
        Member member = ((MemberAccount)account).getMember();
        return member.getUsername() + " - " + member.getName();
    }
}

