/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.accounts.details;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseQueryAction;
import nl.strohalm.cyclos.controls.accounts.details.SearchScheduledPaymentsForm;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.AccountOwner;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.accounts.MemberAccount;
import nl.strohalm.cyclos.entities.accounts.SystemAccountOwner;
import nl.strohalm.cyclos.entities.accounts.transactions.Payment;
import nl.strohalm.cyclos.entities.accounts.transactions.ScheduledPayment;
import nl.strohalm.cyclos.entities.accounts.transactions.ScheduledPaymentQuery;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsEvent;
import nl.strohalm.cyclos.services.accounts.AccountTypeService;
import nl.strohalm.cyclos.services.accounts.MemberAccountTypeQuery;
import nl.strohalm.cyclos.services.accounts.SystemAccountTypeQuery;
import nl.strohalm.cyclos.services.transactions.ScheduledPaymentService;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.RequestHelper;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.DataBinderHelper;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.query.QueryParameters;

public class SearchScheduledPaymentsAction
extends BaseQueryAction {
    private DataBinder<ScheduledPaymentQuery> dataBinder;
    private AccountTypeService accountTypeService;
    private ScheduledPaymentService scheduledPaymentService;

    @Override
    public void onLocalSettingsUpdate(LocalSettingsEvent event) {
        super.onLocalSettingsUpdate(event);
        this.dataBinder = null;
    }

    @Inject
    public void setAccountTypeService(AccountTypeService accountTypeService) {
        this.accountTypeService = accountTypeService;
    }

    @Inject
    public void setScheduledPaymentService(ScheduledPaymentService scheduledPaymentService) {
        this.scheduledPaymentService = scheduledPaymentService;
    }

    @Override
    protected void executeQuery(ActionContext context, QueryParameters queryParameters) {
        ScheduledPaymentQuery query = (ScheduledPaymentQuery)queryParameters;
        List<ScheduledPayment> payments = null;
        if (LoggedUser.isAdministrator()) {
            query.setSearchType(ScheduledPaymentQuery.SearchType.OUTGOING);
        }
        payments = this.scheduledPaymentService.search(query);
        context.getRequest().setAttribute("payments", payments);
    }

    @Override
    protected QueryParameters prepareForm(ActionContext context) {
        List<? extends AccountType> accountTypes;
        SearchScheduledPaymentsForm form = (SearchScheduledPaymentsForm)((Object)context.getForm());
        HttpServletRequest request = context.getRequest();
        ScheduledPaymentQuery query = this.getDataBinder().readFromString(form.getQuery());
        query.fetch(ScheduledPayment.Relationships.TRANSFERS, RelationshipHelper.nested(Payment.Relationships.FROM, MemberAccount.Relationships.MEMBER), RelationshipHelper.nested(Payment.Relationships.TO, MemberAccount.Relationships.MEMBER));
        AccountOwner owner = null;
        if (form.getMemberId() > 0L) {
            owner = (Member)this.elementService.load(form.getMemberId(), new Relationship[0]);
            request.setAttribute("memberId", (Object)form.getMemberId());
        } else {
            owner = context.getAccountOwner();
        }
        query.setOwner(owner);
        if (context.isAdmin() && owner instanceof SystemAccountOwner) {
            SystemAccountTypeQuery satq = new SystemAccountTypeQuery();
            accountTypes = this.accountTypeService.search(satq);
        } else {
            MemberAccountTypeQuery matq = new MemberAccountTypeQuery();
            matq.setOwner((Member)owner);
            accountTypes = this.accountTypeService.search(matq);
        }
        request.setAttribute("accountTypes", accountTypes);
        if (query.getMember() != null) {
            Member member = (Member)this.elementService.load(query.getMember().getId(), Element.Relationships.USER);
            query.setMember(member);
        }
        if (query.getStatusList() == null) {
            query.setStatusGroup(ScheduledPaymentQuery.StatusGroup.OPEN);
            form.setQuery("statusGroup", (Object)ScheduledPaymentQuery.StatusGroup.OPEN);
        }
        RequestHelper.storeEnum(request, ScheduledPaymentQuery.SearchType.class, "searchTypes");
        RequestHelper.storeEnum(request, ScheduledPaymentQuery.StatusGroup.class, "statusGroups");
        request.setAttribute("accountOwner", (Object)owner);
        return query;
    }

    @Override
    protected boolean willExecuteQuery(ActionContext context, QueryParameters queryParameters) throws Exception {
        return true;
    }

    private DataBinder<ScheduledPaymentQuery> getDataBinder() {
        if (this.dataBinder == null) {
            BeanBinder<ScheduledPaymentQuery> binder = BeanBinder.instance(ScheduledPaymentQuery.class);
            LocalSettings localSettings = this.settingsService.getLocalSettings();
            binder.registerBinder("accountType", PropertyBinder.instance(AccountType.class, "accountType"));
            binder.registerBinder("searchType", PropertyBinder.instance(ScheduledPaymentQuery.SearchType.class, "searchType"));
            binder.registerBinder("statusGroup", PropertyBinder.instance(ScheduledPaymentQuery.StatusGroup.class, "statusGroup"));
            binder.registerBinder("period", DataBinderHelper.periodBinder(localSettings, "period"));
            binder.registerBinder("member", PropertyBinder.instance(Member.class, "member"));
            binder.registerBinder("pageParameters", DataBinderHelper.pageBinder());
            this.dataBinder = binder;
        }
        return this.dataBinder;
    }
}

