/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.accounts.details;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.accounts.details.BaseTransferAuthorizationSearchAction;
import nl.strohalm.cyclos.controls.accounts.details.SearchTransferAuthorizationsForm;
import nl.strohalm.cyclos.entities.accounts.MemberAccount;
import nl.strohalm.cyclos.entities.accounts.transactions.Payment;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferAuthorization;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferAuthorizationQuery;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.members.Administrator;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsEvent;
import nl.strohalm.cyclos.utils.EntityHelper;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.RequestHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.DataBinderHelper;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.query.QueryParameters;

public class SearchTransferAuthorizationsAction
extends BaseTransferAuthorizationSearchAction {
    private DataBinder<TransferAuthorizationQuery> dataBinder;

    @Override
    public void onLocalSettingsUpdate(LocalSettingsEvent event) {
        super.onLocalSettingsUpdate(event);
        this.dataBinder = null;
    }

    @Override
    protected void executeQuery(ActionContext context, QueryParameters queryParameters) {
        TransferAuthorizationQuery query = (TransferAuthorizationQuery)queryParameters;
        List<TransferAuthorization> authorizations = this.transferAuthorizationService.searchAuthorizations(query);
        context.getRequest().setAttribute("authorizations", authorizations);
    }

    @Override
    protected QueryParameters prepareForm(ActionContext context) {
        SearchTransferAuthorizationsForm form = (SearchTransferAuthorizationsForm)((Object)context.getForm());
        HttpServletRequest request = context.getRequest();
        TransferAuthorizationQuery query = this.getDataBinder().readFromString(form.getQuery());
        query.fetch(TransferAuthorization.Relationships.BY, RelationshipHelper.nested(TransferAuthorization.Relationships.TRANSFER, Payment.Relationships.FROM, MemberAccount.Relationships.MEMBER), RelationshipHelper.nested(TransferAuthorization.Relationships.TRANSFER, Payment.Relationships.TO, MemberAccount.Relationships.MEMBER));
        if (query.getMember() != null) {
            Member member = (Member)this.elementService.load(query.getMember().getId(), Element.Relationships.USER);
            query.setMember(member);
        }
        long memberId = form.getMemberId();
        Element by = null;
        if (memberId > 0L) {
            by = (Element)this.elementService.load(memberId, Element.Relationships.USER);
            query.setBy(by);
            request.setAttribute("by", by);
        } else if (context.isAdmin()) {
            if (form.getAdminId() > 0L) {
                query.setBy(EntityHelper.reference(Administrator.class, form.getAdminId()));
            }
            if (query.getBy() != null) {
                by = (Element)this.elementService.load(query.getBy().getId(), Element.Relationships.USER);
                query.setBy(by);
            }
        }
        request.setAttribute("transferTypes", this.resolveTransferTypes(by == null ? (Element)context.getElement() : by));
        RequestHelper.storeEnum(request, TransferAuthorization.Action.class, "actions");
        return query;
    }

    @Override
    protected boolean willExecuteQuery(ActionContext context, QueryParameters queryParameters) throws Exception {
        return true;
    }

    private DataBinder<TransferAuthorizationQuery> getDataBinder() {
        if (this.dataBinder == null) {
            BeanBinder<TransferAuthorizationQuery> binder = BeanBinder.instance(TransferAuthorizationQuery.class);
            LocalSettings localSettings = this.settingsService.getLocalSettings();
            binder.registerBinder("period", DataBinderHelper.periodBinder(localSettings, "period"));
            binder.registerBinder("member", PropertyBinder.instance(Member.class, "member"));
            binder.registerBinder("by", PropertyBinder.instance(Administrator.class, "by"));
            binder.registerBinder("action", PropertyBinder.instance(TransferAuthorization.Action.class, "action"));
            binder.registerBinder("transferType", PropertyBinder.instance(TransferType.class, "transferType"));
            binder.registerBinder("pageParameters", DataBinderHelper.pageBinder());
            this.dataBinder = binder;
        }
        return this.dataBinder;
    }
}

