/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.accounts.details;

import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseReceiptPrintAjaxAction;
import nl.strohalm.cyclos.controls.accounts.details.ViewTransactionAction;
import nl.strohalm.cyclos.controls.accounts.details.ViewTransactionForm;
import nl.strohalm.cyclos.entities.accounts.Account;
import nl.strohalm.cyclos.entities.accounts.MemberAccount;
import nl.strohalm.cyclos.entities.accounts.SystemAccount;
import nl.strohalm.cyclos.entities.accounts.transactions.Transfer;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.printsettings.ReceiptPrinterSettings;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.services.transactions.PaymentService;
import org.apache.commons.lang.StringUtils;

public class TransactionReceiptAjaxAction
extends BaseReceiptPrintAjaxAction {
    protected PaymentService paymentService;

    @Inject
    public void setPaymentService(PaymentService paymentService) {
        this.paymentService = paymentService;
    }

    @Override
    protected String resolveText(ActionContext context, ReceiptPrinterSettings receiptPrinterSettings) {
        ViewTransactionForm form = (ViewTransactionForm)((Object)context.getForm());
        long transferId = form.getTransferId();
        Transfer transfer = this.paymentService.load(transferId, ViewTransactionAction.FETCH);
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        StringBuilder out = new StringBuilder();
        out.append(context.message("receipt.transfer.header", localSettings.getApplicationName())).append('\n');
        out.append(context.message("receipt.transfer.textBefore", new Object[0])).append('\n');
        out.append(context.message("receipt.transfer.from", this.ownerString(transfer.getActualFrom()))).append('\n');
        out.append(context.message("receipt.transfer.to", this.ownerString(transfer.getActualTo()))).append('\n');
        out.append(context.message("receipt.transfer.date", localSettings.getDateTimeConverter().toString(transfer.getActualDate()))).append('\n');
        if (StringUtils.isNotEmpty((String)transfer.getTransactionNumber())) {
            out.append(context.message("receipt.transfer.transactionNumber", transfer.getTransactionNumber())).append('\n');
        }
        out.append(context.message("receipt.transfer.amount", localSettings.getUnitsConverter(transfer.getFrom().getType().getCurrency().getPattern()).toString(transfer.getActualAmount()))).append('\n');
        if (transfer.getProcessDate() == null) {
            out.append(context.message("receipt.transfer.status", context.message("payment.status." + transfer.getStatus(), new Object[0]))).append('\n');
        }
        if (StringUtils.isNotEmpty((String)receiptPrinterSettings.getPaymentAdditionalMessage())) {
            out.append('\n').append(receiptPrinterSettings.getPaymentAdditionalMessage()).append('\n');
        }
        out.append(context.message("receipt.transfer.textAfter", new Object[0]));
        return out.toString();
    }

    private String ownerString(Account account) {
        if (account instanceof SystemAccount) {
            return account.getOwnerName();
        }
        Member member = ((MemberAccount)account).getMember();
        return member.getUsername() + " - " + member.getName();
    }
}

