/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.accounts.details;

import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.accounts.details.BaseTransferAuthorizationSearchAction;
import nl.strohalm.cyclos.controls.accounts.details.TransfersAwaitingAuthorizationForm;
import nl.strohalm.cyclos.entities.accounts.MemberAccount;
import nl.strohalm.cyclos.entities.accounts.transactions.AuthorizationLevel;
import nl.strohalm.cyclos.entities.accounts.transactions.Payment;
import nl.strohalm.cyclos.entities.accounts.transactions.Transfer;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.accounts.transactions.TransfersAwaitingAuthorizationQuery;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsEvent;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.DataBinderHelper;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.query.QueryParameters;

public class TransfersAwaitingAuthorizationAction
extends BaseTransferAuthorizationSearchAction {
    private DataBinder<TransfersAwaitingAuthorizationQuery> dataBinder;

    @Override
    public void onLocalSettingsUpdate(LocalSettingsEvent event) {
        super.onLocalSettingsUpdate(event);
        this.dataBinder = null;
    }

    @Override
    protected void executeQuery(ActionContext context, QueryParameters queryParameters) {
        TransfersAwaitingAuthorizationQuery query = (TransfersAwaitingAuthorizationQuery)queryParameters;
        List<Transfer> list = this.transferAuthorizationService.searchTransfersAwaitingAuthorization(query);
        context.getRequest().setAttribute("transfers", list);
    }

    @Override
    protected QueryParameters prepareForm(ActionContext context) {
        TransfersAwaitingAuthorizationForm form = (TransfersAwaitingAuthorizationForm)((Object)context.getForm());
        TransfersAwaitingAuthorizationQuery query = this.getDataBinder().readFromString(form.getQuery());
        query.fetch(RelationshipHelper.nested(Payment.Relationships.FROM, MemberAccount.Relationships.MEMBER), RelationshipHelper.nested(Payment.Relationships.TO, MemberAccount.Relationships.MEMBER));
        if (query.getMember() != null) {
            Member member = (Member)this.elementService.load(query.getMember().getId(), Element.Relationships.USER);
            query.setMember(member);
        }
        HttpServletRequest request = context.getRequest();
        List<TransferType> transferTypes = this.resolveTransferTypes((Element)context.getElement());
        boolean showBrokerCheck = false;
        if (context.isAdmin()) {
            for (TransferType transferType : transferTypes) {
                Collection<AuthorizationLevel> levels = transferType.getAuthorizationLevels();
                for (AuthorizationLevel level : levels) {
                    if (level.getAuthorizer() != AuthorizationLevel.Authorizer.BROKER) continue;
                    showBrokerCheck = true;
                    break;
                }
                if (!showBrokerCheck) continue;
                break;
            }
        }
        request.setAttribute("transferTypes", transferTypes);
        request.setAttribute("showBrokerCheck", (Object)showBrokerCheck);
        return query;
    }

    @Override
    protected boolean willExecuteQuery(ActionContext context, QueryParameters queryParameters) throws Exception {
        return true;
    }

    private DataBinder<TransfersAwaitingAuthorizationQuery> getDataBinder() {
        if (this.dataBinder == null) {
            LocalSettings localSettings = this.settingsService.getLocalSettings();
            BeanBinder<TransfersAwaitingAuthorizationQuery> binder = BeanBinder.instance(TransfersAwaitingAuthorizationQuery.class);
            binder.registerBinder("member", PropertyBinder.instance(Member.class, "member"));
            binder.registerBinder("onlyWithoutBroker", PropertyBinder.instance(Boolean.TYPE, "onlyWithoutBroker"));
            binder.registerBinder("transferType", PropertyBinder.instance(TransferType.class, "transferType"));
            binder.registerBinder("period", DataBinderHelper.periodBinder(localSettings, "period"));
            binder.registerBinder("transactionNumber", PropertyBinder.instance(String.class, "transactionNumber"));
            binder.registerBinder("pageParameters", DataBinderHelper.pageBinder());
            this.dataBinder = binder;
        }
        return this.dataBinder;
    }
}

