/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.accounts.details;

import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.accounts.details.ViewTransactionForm;
import nl.strohalm.cyclos.controls.payments.scheduled.ScheduledPaymentForm;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.AccountOwner;
import nl.strohalm.cyclos.entities.accounts.MemberAccount;
import nl.strohalm.cyclos.entities.accounts.transactions.Payment;
import nl.strohalm.cyclos.entities.accounts.transactions.ScheduledPayment;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.customization.fields.PaymentCustomField;
import nl.strohalm.cyclos.entities.members.Administrator;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.Operator;
import nl.strohalm.cyclos.services.customization.PaymentCustomFieldService;
import nl.strohalm.cyclos.services.transactions.ScheduledPaymentService;
import nl.strohalm.cyclos.utils.CustomFieldHelper;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.validation.RequiredError;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.commons.lang.StringUtils;

public class ViewScheduledPaymentAction
extends BaseFormAction {
    public static final Relationship[] FETCH = new Relationship[]{Payment.Relationships.CUSTOM_VALUES, RelationshipHelper.nested(Payment.Relationships.FROM, MemberAccount.Relationships.MEMBER), RelationshipHelper.nested(Payment.Relationships.TO, MemberAccount.Relationships.MEMBER), RelationshipHelper.nested(Payment.Relationships.TYPE, TransferType.Relationships.TO), Payment.Relationships.BY, ScheduledPayment.Relationships.TRANSFERS};
    private PaymentCustomFieldService paymentCustomFieldService;
    protected ScheduledPaymentService scheduledPaymentService;
    private CustomFieldHelper customFieldHelper;

    @Inject
    public void setCustomFieldHelper(CustomFieldHelper customFieldHelper) {
        this.customFieldHelper = customFieldHelper;
    }

    @Inject
    public void setPaymentCustomFieldService(PaymentCustomFieldService paymentCustomFieldService) {
        this.paymentCustomFieldService = paymentCustomFieldService;
    }

    @Inject
    public void setScheduledPaymentService(ScheduledPaymentService scheduledPaymentService) {
        this.scheduledPaymentService = scheduledPaymentService;
    }

    protected void checkTransactionPassword(ActionContext context, ScheduledPayment payment) {
        if (this.shouldValidateTransactionPassword(context, payment)) {
            Object form = context.getForm();
            String transactionPassword = form instanceof ViewTransactionForm ? ((ViewTransactionForm)((Object)form)).getTransactionPassword() : ((ScheduledPaymentForm)((Object)form)).getTransactionPassword();
            context.checkTransactionPassword(transactionPassword);
        }
    }

    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        HttpServletRequest request = context.getRequest();
        ScheduledPayment payment = this.resolveScheduledPayment(context);
        boolean canCancel = this.scheduledPaymentService.canCancel(payment);
        boolean canBlock = this.scheduledPaymentService.canBlock(payment);
        boolean canUnblock = this.scheduledPaymentService.canUnblock(payment);
        boolean canPayNow = false;
        if (payment.getTransfers().size() == 1) {
            canPayNow = this.scheduledPaymentService.canPayNow(payment.getTransfers().iterator().next());
        }
        Object comments = null;
        boolean showBy = false;
        Element by = payment.getBy();
        if (by != null) {
            if (by instanceof Administrator) {
                if (context.isAdmin()) {
                    request.setAttribute("byAdmin", (Object)by);
                } else {
                    request.setAttribute("bySystem", (Object)true);
                }
                showBy = true;
            } else if (by instanceof Operator && (context.isMemberOf((Operator)by) || ((Entity)context.getElement()).equals(by))) {
                request.setAttribute("byOperator", (Object)by);
                showBy = true;
            } else {
                AccountOwner fromOwner = payment.getFrom().getOwner();
                Member member = (Member)by.getAccountOwner();
                request.setAttribute("byMember", (Object)member);
                showBy = !member.equals(fromOwner);
            }
        }
        List<PaymentCustomField> customFields = this.paymentCustomFieldService.list(payment.getType(), true);
        Collection<CustomFieldHelper.Entry> entries = this.customFieldHelper.buildEntries(customFields, payment.getCustomValues());
        request.setAttribute("customFields", entries);
        if (canCancel || canBlock || canUnblock) {
            request.setAttribute("requestTransactionPassword", (Object)this.shouldValidateTransactionPassword(context, payment));
        }
        if (canPayNow) {
            ScheduledPaymentForm form = (ScheduledPaymentForm)((Object)context.getForm());
            form.setShowActions(true);
        }
        request.setAttribute("canCancel", (Object)canCancel);
        request.setAttribute("canBlock", (Object)canBlock);
        request.setAttribute("canPayNow", (Object)canPayNow);
        request.setAttribute("canUnblock", (Object)canUnblock);
        request.setAttribute("comments", comments);
        request.setAttribute("showBy", (Object)showBy);
        request.setAttribute("payment", (Object)payment);
    }

    protected ScheduledPayment resolveScheduledPayment(ActionContext context) {
        ScheduledPaymentForm form = (ScheduledPaymentForm)((Object)context.getForm());
        long id = form.getPaymentId();
        if (id <= 0L) {
            throw new ValidationException();
        }
        return this.scheduledPaymentService.load(form.getPaymentId(), FETCH);
    }

    protected boolean shouldValidateTransactionPassword(ActionContext context, ScheduledPayment scheduledPayment) {
        if (context.getAccountOwner().equals(scheduledPayment.getFromOwner())) {
            return context.isTransactionPasswordEnabled(scheduledPayment.getType().getFrom());
        }
        return context.isTransactionPasswordEnabled();
    }

    @Override
    protected void validateForm(ActionContext context) {
        ScheduledPaymentForm form;
        if (this.shouldValidateTransactionPassword(context, this.resolveScheduledPayment(context)) && StringUtils.isEmpty((String)(form = (ScheduledPaymentForm)((Object)context.getForm())).getTransactionPassword())) {
            throw new ValidationException("_transactionPassword", "login.transactionPassword", new RequiredError(new Object[0]));
        }
    }
}

