/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.accounts.details;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.access.AdminSystemPermission;
import nl.strohalm.cyclos.access.BrokerPermission;
import nl.strohalm.cyclos.access.MemberPermission;
import nl.strohalm.cyclos.access.OperatorPermission;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.accounts.details.ViewTransactionForm;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.Account;
import nl.strohalm.cyclos.entities.accounts.AccountOwner;
import nl.strohalm.cyclos.entities.accounts.MemberAccount;
import nl.strohalm.cyclos.entities.accounts.transactions.AuthorizationLevel;
import nl.strohalm.cyclos.entities.accounts.transactions.Payment;
import nl.strohalm.cyclos.entities.accounts.transactions.ScheduledPayment;
import nl.strohalm.cyclos.entities.accounts.transactions.Transfer;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferAuthorization;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.customization.fields.PaymentCustomField;
import nl.strohalm.cyclos.entities.groups.AdminGroup;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.SystemGroup;
import nl.strohalm.cyclos.entities.members.Administrator;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.Operator;
import nl.strohalm.cyclos.services.accounts.guarantees.GuaranteeService;
import nl.strohalm.cyclos.services.accounts.rates.RateService;
import nl.strohalm.cyclos.services.customization.PaymentCustomFieldService;
import nl.strohalm.cyclos.services.transactions.PaymentService;
import nl.strohalm.cyclos.services.transactions.ScheduledPaymentService;
import nl.strohalm.cyclos.services.transactions.TransferAuthorizationService;
import nl.strohalm.cyclos.utils.CustomFieldHelper;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.validation.RequiredError;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class ViewTransactionAction
extends BaseFormAction {
    public static final Relationship[] FETCH = new Relationship[]{Transfer.Relationships.CHILDREN, Payment.Relationships.CUSTOM_VALUES, RelationshipHelper.nested(Payment.Relationships.FROM, MemberAccount.Relationships.MEMBER, Element.Relationships.GROUP), RelationshipHelper.nested(Payment.Relationships.FROM, Account.Relationships.TYPE), RelationshipHelper.nested(Payment.Relationships.TO, MemberAccount.Relationships.MEMBER, Element.Relationships.GROUP), RelationshipHelper.nested(Payment.Relationships.TO, Account.Relationships.TYPE), RelationshipHelper.nested(Payment.Relationships.TYPE, TransferType.Relationships.TO), RelationshipHelper.nested(Transfer.Relationships.SCHEDULED_PAYMENT, ScheduledPayment.Relationships.TRANSFERS), Payment.Relationships.BY, Transfer.Relationships.RECEIVER, Transfer.Relationships.NEXT_AUTHORIZATION_LEVEL, Transfer.Relationships.AUTHORIZATIONS, Transfer.Relationships.CHARGEBACK_OF, Transfer.Relationships.CHARGED_BACK_BY};
    protected ScheduledPaymentService scheduledPaymentService;
    protected TransferAuthorizationService transferAuthorizationService;
    protected PaymentService paymentService;
    protected PaymentCustomFieldService paymentCustomFieldService;
    protected RateService rateService;
    protected GuaranteeService guaranteeService;
    private CustomFieldHelper customFieldHelper;

    @Inject
    public void setCustomFieldHelper(CustomFieldHelper customFieldHelper) {
        this.customFieldHelper = customFieldHelper;
    }

    @Inject
    public final void setGuaranteeService(GuaranteeService guaranteeService) {
        this.guaranteeService = guaranteeService;
    }

    @Inject
    public final void setPaymentCustomFieldService(PaymentCustomFieldService paymentCustomFieldService) {
        this.paymentCustomFieldService = paymentCustomFieldService;
    }

    @Inject
    public final void setPaymentService(PaymentService paymentService) {
        this.paymentService = paymentService;
    }

    @Inject
    public final void setRateService(RateService rateService) {
        this.rateService = rateService;
    }

    @Inject
    public final void setScheduledPaymentService(ScheduledPaymentService scheduledPaymentService) {
        this.scheduledPaymentService = scheduledPaymentService;
    }

    @Inject
    public final void setTransferAuthorizationService(TransferAuthorizationService transferAuthorizationService) {
        this.transferAuthorizationService = transferAuthorizationService;
    }

    protected void checkTransactionPassword(ActionContext context, Transfer transfer) {
        if (this.shouldValidateTransactionPassword(context, transfer)) {
            ViewTransactionForm form = (ViewTransactionForm)((Object)context.getForm());
            context.checkTransactionPassword(form.getTransactionPassword());
        }
    }

    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        Element by;
        boolean showHierarchy;
        HttpServletRequest request = context.getRequest();
        ViewTransactionForm form = (ViewTransactionForm)((Object)context.getForm());
        Transfer transfer = this.resolveTransfer(context);
        String unitsPattern = transfer.getType().getFrom().getCurrency().getPattern();
        request.setAttribute("unitsPattern", (Object)unitsPattern);
        List<PaymentCustomField> customFields = this.paymentCustomFieldService.list(transfer.getType(), true);
        Collection<CustomFieldHelper.Entry> entries = this.customFieldHelper.buildEntries(customFields, transfer.getCustomValues());
        request.setAttribute("customFields", entries);
        ScheduledPayment scheduledPayment = transfer.getScheduledPayment();
        ScheduledPayment scheduledPayment2 = scheduledPayment = scheduledPayment == null ? null : this.scheduledPaymentService.load(scheduledPayment.getId(), ScheduledPayment.Relationships.TRANSFERS);
        if (scheduledPayment != null) {
            int number = scheduledPayment.getTransfers().indexOf(transfer) + 1;
            request.setAttribute("scheduledPayment", (Object)scheduledPayment);
            request.setAttribute("scheduledPaymentNumber", (Object)number);
            request.setAttribute("scheduledPaymentCount", (Object)scheduledPayment.getTransfers().size());
        }
        boolean canCancel = false;
        boolean canAuthorize = false;
        boolean suppressDeny = false;
        boolean canChargeback = false;
        String comments = null;
        if (transfer.isRoot() && transfer.getProcessDate() == null || !CollectionUtils.isEmpty(transfer.getAuthorizations())) {
            TransferAuthorization lastAuthorization;
            if (transfer.getStatus() == Payment.Status.PENDING) {
                AuthorizationLevel currentAuthorizationLevel = transfer.getNextAuthorizationLevel();
                AuthorizationLevel.Authorizer authorizer = currentAuthorizationLevel.getAuthorizer();
                AccountOwner fromOwner = transfer.getFromOwner();
                if (context.isAdmin() && (authorizer == AuthorizationLevel.Authorizer.ADMIN || authorizer == AuthorizationLevel.Authorizer.BROKER)) {
                    AdminGroup adminGroup = (AdminGroup)context.getGroup();
                    if (currentAuthorizationLevel.getAdminGroups().contains(adminGroup)) {
                        canAuthorize = transfer.isActuallyFromSystem() ? this.permissionService.hasPermission(AdminSystemPermission.PAYMENTS_AUTHORIZE) : this.permissionService.hasPermission(AdminMemberPermission.PAYMENTS_AUTHORIZE);
                    }
                } else if (context.isBroker() && authorizer == AuthorizationLevel.Authorizer.BROKER && !transfer.isFromSystem()) {
                    Member member = (Member)fromOwner;
                    if (context.isBrokerOf(member)) {
                        canAuthorize = this.permissionService.hasPermission(BrokerPermission.MEMBER_PAYMENTS_AUTHORIZE);
                    }
                } else if ((context.isMember() || context.isOperator()) && authorizer == AuthorizationLevel.Authorizer.RECEIVER && !transfer.isToSystem()) {
                    if (transfer.getToOwner().equals(context.getAccountOwner())) {
                        canAuthorize = context.isMember() && this.permissionService.hasPermission(MemberPermission.PAYMENTS_AUTHORIZE) || context.isOperator() && this.permissionService.hasPermission(OperatorPermission.PAYMENTS_AUTHORIZE);
                    }
                } else if ((context.isMember() || context.isOperator()) && authorizer == AuthorizationLevel.Authorizer.PAYER && !transfer.isFromSystem()) {
                    if (transfer.getFromOwner().equals(context.getAccountOwner())) {
                        canAuthorize = context.isMember() && this.permissionService.hasPermission(MemberPermission.PAYMENTS_AUTHORIZE) || context.isOperator() && this.permissionService.hasPermission(OperatorPermission.PAYMENTS_AUTHORIZE);
                    }
                    suppressDeny = true;
                }
                if (!canAuthorize && scheduledPayment == null) {
                    if (fromOwner.equals(context.getAccountOwner())) {
                        canCancel = context.isAdmin() ? this.permissionService.hasPermission(AdminSystemPermission.PAYMENTS_CANCEL) : context.isMember() && this.permissionService.hasPermission(MemberPermission.PAYMENTS_CANCEL_AUTHORIZED) || context.isOperator() && this.permissionService.hasPermission(OperatorPermission.PAYMENTS_CANCEL_AUTHORIZED);
                    } else if (transfer.getToOwner().equals(context.getAccountOwner())) {
                        SystemGroup group = (SystemGroup)this.groupService.load(((Entity)context.getGroup()).getId(), SystemGroup.Relationships.CHARGEBACK_TRANSFER_TYPES);
                        if (group.getChargebackTransferTypes().contains(transfer.getType()) && this.paymentService.canChargeback(transfer, true)) {
                            canCancel = context.isMember() && this.permissionService.hasPermission(MemberPermission.PAYMENTS_CHARGEBACK);
                        }
                    } else if (context.isAdmin()) {
                        canCancel = this.permissionService.hasPermission(AdminMemberPermission.PAYMENTS_CANCEL_AUTHORIZED_AS_MEMBER);
                    } else if (fromOwner instanceof Member) {
                        Member fromMember = (Member)fromOwner;
                        boolean bl = canCancel = context.isBrokerOf(fromMember) && this.permissionService.hasPermission(BrokerPermission.MEMBER_PAYMENTS_CANCEL_AUTHORIZED_AS_MEMBER);
                    }
                }
            }
            if (CollectionUtils.isNotEmpty(transfer.getAuthorizations()) && ((lastAuthorization = new LinkedList<TransferAuthorization>(transfer.getAuthorizations()).getLast()).isShowToMember() || lastAuthorization.getLevel().getAuthorizer() == AuthorizationLevel.Authorizer.BROKER && ((Entity)context.getElement()).equals(lastAuthorization.getBy()))) {
                comments = lastAuthorization.getComments();
            }
        }
        boolean canPayNow = this.scheduledPaymentService.canPayNow(transfer);
        request.setAttribute("canChargeback", (Object)(this.paymentService.hasPermissionsToChargeback(transfer) && this.paymentService.canChargeback(transfer, false) ? 1 : 0));
        TransferType.TransactionHierarchyVisibility transactionHierarchyVisibility = transfer.getType().getTransactionHierarchyVisibility();
        boolean bl = showHierarchy = transactionHierarchyVisibility == null ? false : transactionHierarchyVisibility.isVisibleTo(((Group)context.getGroup()).getNature());
        if (showHierarchy) {
            Transfer parent = transfer.getParent();
            if (parent != null && this.paymentService.isVisible(parent)) {
                parent = this.paymentService.load(parent.getId(), FETCH);
                List<PaymentCustomField> parentCustomFields = this.paymentCustomFieldService.list(parent.getType(), true);
                Collection<CustomFieldHelper.Entry> parentEntries = this.customFieldHelper.buildEntries(parentCustomFields, parent.getCustomValues());
                request.setAttribute("parentCustomFields", parentEntries);
                request.setAttribute("parent", (Object)parent);
            }
            ArrayList<Transfer> children = new ArrayList<Transfer>(transfer.getChildren());
            Iterator it = children.iterator();
            while (it.hasNext()) {
                if (this.paymentService.isVisible((Payment)it.next())) continue;
                it.remove();
            }
            request.setAttribute("children", children);
        }
        if ((by = transfer.getReceiver()) == null) {
            by = transfer.getBy();
        }
        boolean showBy = false;
        if (by != null) {
            if (by instanceof Administrator) {
                if (context.isAdmin()) {
                    request.setAttribute("byAdmin", (Object)by);
                } else {
                    request.setAttribute("bySystem", (Object)true);
                }
                showBy = true;
            } else if (by instanceof Operator && (context.isMemberOf((Operator)by) || ((Entity)context.getElement()).equals(by)) || by instanceof Operator && context.getAccountOwner().equals(transfer.getFromOwner())) {
                request.setAttribute("byOperator", (Object)by);
                showBy = true;
            } else {
                AccountOwner fromOwner = transfer.getFrom().getOwner();
                Member member = (Member)by.getAccountOwner();
                request.setAttribute("byMember", (Object)member);
                boolean bl2 = showBy = !member.equals(fromOwner);
            }
        }
        if (canCancel || canAuthorize) {
            boolean alreadyAuthorized = this.transferAuthorizationService.hasAlreadyAuthorized(transfer);
            if (!alreadyAuthorized) {
                request.setAttribute("canCancel", (Object)canCancel);
                request.setAttribute("canAuthorize", (Object)canAuthorize);
                request.setAttribute("suppressDeny", (Object)suppressDeny);
                if (!context.getAccountOwner().equals(transfer.getToOwner())) {
                    request.setAttribute("showCommentsCheckBox", (Object)canAuthorize);
                }
            }
            request.setAttribute("alreadyAuthorized", (Object)alreadyAuthorized);
        }
        if (canCancel || canAuthorize) {
            request.setAttribute("requestTransactionPassword", (Object)this.shouldValidateTransactionPassword(context, transfer));
            request.setAttribute("showActions", (Object)true);
        }
        if (context.isAdmin()) {
            request.setAttribute("authorizations", transfer.getAuthorizations());
        }
        request.setAttribute("canPayNow", (Object)canPayNow);
        request.setAttribute("comments", (Object)comments);
        request.setAttribute("showBy", (Object)showBy);
        request.setAttribute("transfer", (Object)transfer);
        if (form.getMemberId() > 0L) {
            request.setAttribute("memberId", (Object)form.getMemberId());
        }
        if (form.getTypeId() > 0L) {
            request.setAttribute("typeId", (Object)form.getTypeId());
        }
        request.setAttribute("guarantee", (Object)this.guaranteeService.loadFromTransfer(transfer));
    }

    protected Map<String, Object> resolveForwardParams(ActionContext context) {
        ViewTransactionForm form = (ViewTransactionForm)((Object)context.getForm());
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("transferId", form.getTransferId());
        params.put("memberId", form.getMemberId());
        params.put("typeId", form.getTypeId());
        return params;
    }

    protected Transfer resolveTransfer(ActionContext context) {
        ViewTransactionForm form = (ViewTransactionForm)((Object)context.getForm());
        long id = form.getTransferId();
        if (id <= 0L) {
            throw new ValidationException();
        }
        return this.paymentService.load(id, FETCH);
    }

    protected boolean shouldValidateTransactionPassword(ActionContext context, Transfer transfer) {
        if (context.getAccountOwner().equals(transfer.getToOwner())) {
            return context.isTransactionPasswordEnabled(transfer.getType().getTo());
        }
        if (context.getAccountOwner().equals(transfer.getFromOwner())) {
            return context.isTransactionPasswordEnabled(transfer.getType().getFrom());
        }
        return context.isTransactionPasswordEnabled();
    }

    @Override
    protected void validateForm(ActionContext context) {
        ViewTransactionForm form;
        if (this.shouldValidateTransactionPassword(context, this.resolveTransfer(context)) && StringUtils.isEmpty((String)(form = (ViewTransactionForm)((Object)context.getForm())).getTransactionPassword())) {
            throw new ValidationException("_transactionPassword", "login.transactionPassword", new RequiredError(new Object[0]));
        }
    }
}

