/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.accounts.external;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.access.AdminSystemPermission;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.accounts.external.EditExternalAccountForm;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.accounts.MemberAccountType;
import nl.strohalm.cyclos.entities.accounts.SystemAccountType;
import nl.strohalm.cyclos.entities.accounts.external.ExternalAccount;
import nl.strohalm.cyclos.services.accounts.AccountTypeService;
import nl.strohalm.cyclos.services.accounts.MemberAccountTypeQuery;
import nl.strohalm.cyclos.services.accounts.SystemAccountTypeQuery;
import nl.strohalm.cyclos.services.accounts.external.ExternalAccountService;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.conversion.IdConverter;
import org.apache.struts.action.ActionForward;

public class EditExternalAccountAction
extends BaseFormAction {
    private ExternalAccountService externalAccountService;
    private DataBinder<ExternalAccount> dataBinder;
    private AccountTypeService accountTypeService;

    @Inject
    public void setAccountTypeService(AccountTypeService accountTypeService) {
        this.accountTypeService = accountTypeService;
    }

    @Inject
    public void setExternalAccountService(ExternalAccountService externalAccountService) {
        this.externalAccountService = externalAccountService;
    }

    @Override
    protected ActionForward handleSubmit(ActionContext context) throws Exception {
        EditExternalAccountForm form = (EditExternalAccountForm)((Object)context.getForm());
        ExternalAccount externalAccount = this.getDataBinder().readFromString(form.getExternalAccount());
        boolean isInsert = externalAccount.isTransient();
        externalAccount = this.externalAccountService.save(externalAccount);
        if (isInsert) {
            context.sendMessage("externalAccount.inserted", new Object[0]);
        } else {
            context.sendMessage("externalAccount.modified", new Object[0]);
        }
        return ActionHelper.redirectWithParam(context.getRequest(), context.getSuccessForward(), "externalAccountId", externalAccount.getId());
    }

    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        ExternalAccount externalAccount;
        HttpServletRequest request = context.getRequest();
        EditExternalAccountForm form = (EditExternalAccountForm)((Object)context.getForm());
        long id = form.getExternalAccountId();
        boolean isInsert = id <= 0L;
        boolean editable = this.permissionService.hasPermission(AdminSystemPermission.EXTERNAL_ACCOUNTS_MANAGE);
        if (isInsert) {
            externalAccount = new ExternalAccount();
            editable = true;
        } else {
            externalAccount = this.externalAccountService.load(id, new Relationship[0]);
        }
        this.getDataBinder().writeAsString(form.getExternalAccount(), externalAccount);
        SystemAccountTypeQuery querySystem = new SystemAccountTypeQuery();
        MemberAccountTypeQuery queryMember = new MemberAccountTypeQuery();
        List<? extends AccountType> accountSystems = this.accountTypeService.search(querySystem);
        List<? extends AccountType> accountMembers = this.accountTypeService.search(queryMember);
        request.setAttribute("systemAccounts", accountSystems);
        request.setAttribute("memberAccounts", accountMembers);
        request.setAttribute("externalAccount", (Object)externalAccount);
        request.setAttribute("isInsert", (Object)isInsert);
        request.setAttribute("editable", (Object)editable);
    }

    @Override
    protected void validateForm(ActionContext context) {
        EditExternalAccountForm form = (EditExternalAccountForm)((Object)context.getForm());
        ExternalAccount externalAccount = this.getDataBinder().readFromString(form.getExternalAccount());
        this.externalAccountService.validate(externalAccount);
    }

    private DataBinder<ExternalAccount> getDataBinder() {
        if (this.dataBinder == null) {
            BeanBinder<ExternalAccount> binder = BeanBinder.instance(ExternalAccount.class);
            binder.registerBinder("id", PropertyBinder.instance(Long.class, "id", IdConverter.instance()));
            binder.registerBinder("name", PropertyBinder.instance(String.class, "name"));
            binder.registerBinder("systemAccountType", PropertyBinder.instance(SystemAccountType.class, "systemAccountType"));
            binder.registerBinder("memberAccountType", PropertyBinder.instance(MemberAccountType.class, "memberAccountType"));
            binder.registerBinder("description", PropertyBinder.instance(String.class, "description"));
            this.dataBinder = binder;
        }
        return this.dataBinder;
    }
}

