/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.accounts.external;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.access.AdminSystemPermission;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.accounts.external.EditExternalTransferTypeForm;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.external.ExternalAccount;
import nl.strohalm.cyclos.entities.accounts.external.ExternalTransferType;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferTypeQuery;
import nl.strohalm.cyclos.services.accounts.external.ExternalAccountService;
import nl.strohalm.cyclos.services.accounts.external.ExternalTransferTypeService;
import nl.strohalm.cyclos.services.transactions.TransactionContext;
import nl.strohalm.cyclos.services.transfertypes.TransferTypeService;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.RequestHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.conversion.IdConverter;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.struts.action.ActionForward;

public class EditExternalTransferTypeAction
extends BaseFormAction {
    private ExternalTransferTypeService externalTransferTypeService;
    private DataBinder<ExternalTransferType> dataBinder;
    private TransferTypeService transferTypeService;
    private ExternalAccountService externalAccountService;

    @Inject
    public void setExternalAccountService(ExternalAccountService externalAccountService) {
        this.externalAccountService = externalAccountService;
    }

    @Inject
    public void setExternalTransferTypeService(ExternalTransferTypeService externalTransferTypeService) {
        this.externalTransferTypeService = externalTransferTypeService;
    }

    @Inject
    public void setTransferTypeService(TransferTypeService transferTypeService) {
        this.transferTypeService = transferTypeService;
    }

    @Override
    protected ActionForward handleSubmit(ActionContext context) throws Exception {
        EditExternalTransferTypeForm form = (EditExternalTransferTypeForm)((Object)context.getForm());
        ExternalTransferType externalTransferType = this.getDataBinder().readFromString(form.getExternalTransferType());
        boolean isInsert = externalTransferType.isTransient();
        externalTransferType = this.externalTransferTypeService.save(externalTransferType);
        if (isInsert) {
            context.sendMessage("externalTransferType.inserted", new Object[0]);
        } else {
            context.sendMessage("externalTransferType.modified", new Object[0]);
        }
        return ActionHelper.redirectWithParam(context.getRequest(), context.getSuccessForward(), "externalAccountId", externalTransferType.getAccount().getId());
    }

    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        ExternalAccount externalAccount;
        ExternalTransferType externalTransferType;
        HttpServletRequest request = context.getRequest();
        EditExternalTransferTypeForm form = (EditExternalTransferTypeForm)((Object)context.getForm());
        long id = form.getExternalTransferTypeId();
        boolean isInsert = id <= 0L;
        boolean editable = this.permissionService.hasPermission(AdminSystemPermission.EXTERNAL_ACCOUNTS_MANAGE);
        if (isInsert) {
            externalTransferType = new ExternalTransferType();
            long account = form.getAccount();
            if (account <= 0L) {
                throw new ValidationException();
            }
            externalAccount = this.externalAccountService.load(account, new Relationship[0]);
            externalTransferType.setAccount(externalAccount);
            editable = true;
        } else {
            externalTransferType = this.externalTransferTypeService.load(id, ExternalTransferType.Relationships.ACCOUNT);
            externalAccount = externalTransferType.getAccount();
        }
        this.getDataBinder().writeAsString(form.getExternalTransferType(), externalTransferType);
        RequestHelper.storeEnum(request, ExternalTransferType.Action.class, "actions");
        TransferTypeQuery toMemberQuery = new TransferTypeQuery();
        toMemberQuery.setContext(TransactionContext.AUTOMATIC);
        toMemberQuery.setFromAccountType(externalAccount.getSystemAccountType());
        toMemberQuery.setToAccountType(externalAccount.getMemberAccountType());
        List<TransferType> toMemberTransferTypes = this.transferTypeService.search(toMemberQuery);
        request.setAttribute("toMemberTransferTypes", toMemberTransferTypes);
        TransferTypeQuery toSystemQuery = new TransferTypeQuery();
        toSystemQuery.setContext(TransactionContext.AUTOMATIC);
        toSystemQuery.setFromAccountType(externalAccount.getMemberAccountType());
        toSystemQuery.setToAccountType(externalAccount.getSystemAccountType());
        List<TransferType> toSystemTransferTypes = this.transferTypeService.search(toSystemQuery);
        request.setAttribute("toSystemTransferTypes", toSystemTransferTypes);
        request.setAttribute("externalTransferType", (Object)externalTransferType);
        request.setAttribute("isInsert", (Object)isInsert);
        request.setAttribute("editable", (Object)editable);
        request.setAttribute("account", (Object)externalAccount);
    }

    @Override
    protected void validateForm(ActionContext context) {
        EditExternalTransferTypeForm form = (EditExternalTransferTypeForm)((Object)context.getForm());
        ExternalTransferType externalTransferType = this.getDataBinder().readFromString(form.getExternalTransferType());
        this.externalTransferTypeService.validate(externalTransferType);
    }

    private DataBinder<ExternalTransferType> getDataBinder() {
        if (this.dataBinder == null) {
            BeanBinder<ExternalTransferType> binder = BeanBinder.instance(ExternalTransferType.class);
            binder.registerBinder("id", PropertyBinder.instance(Long.class, "id", IdConverter.instance()));
            binder.registerBinder("name", PropertyBinder.instance(String.class, "name"));
            binder.registerBinder("code", PropertyBinder.instance(String.class, "code"));
            binder.registerBinder("description", PropertyBinder.instance(String.class, "description"));
            binder.registerBinder("action", PropertyBinder.instance(ExternalTransferType.Action.class, "action"));
            binder.registerBinder("account", PropertyBinder.instance(ExternalAccount.class, "account"));
            binder.registerBinder("transferType", PropertyBinder.instance(TransferType.class, "transferType"));
            this.dataBinder = binder;
        }
        return this.dataBinder;
    }
}

