/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.accounts.external;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.access.AdminSystemPermission;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseQueryAction;
import nl.strohalm.cyclos.controls.accounts.external.ExternalAccountHistoryForm;
import nl.strohalm.cyclos.entities.accounts.external.ExternalAccount;
import nl.strohalm.cyclos.entities.accounts.external.ExternalTransfer;
import nl.strohalm.cyclos.entities.accounts.external.ExternalTransferAction;
import nl.strohalm.cyclos.entities.accounts.external.ExternalTransferImport;
import nl.strohalm.cyclos.entities.accounts.external.ExternalTransferQuery;
import nl.strohalm.cyclos.entities.accounts.external.ExternalTransferType;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsChangeListener;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsEvent;
import nl.strohalm.cyclos.services.accounts.external.ExternalAccountService;
import nl.strohalm.cyclos.services.accounts.external.ExternalTransferImportService;
import nl.strohalm.cyclos.services.accounts.external.ExternalTransferService;
import nl.strohalm.cyclos.services.transactions.NegativeAllowedTransactionSummaryVO;
import nl.strohalm.cyclos.services.transactions.TransactionSummaryVO;
import nl.strohalm.cyclos.utils.BigDecimalHelper;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.RequestHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.DataBinderHelper;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.conversion.ReferenceConverter;
import nl.strohalm.cyclos.utils.query.QueryParameters;
import nl.strohalm.cyclos.utils.validation.ValidationException;

public class ExternalAccountHistoryAction
extends BaseQueryAction
implements LocalSettingsChangeListener {
    private DataBinder<ExternalTransferQuery> dataBinder;
    private ExternalAccountService externalAccountService;
    private ExternalTransferImportService externalTransferImportService;
    private ExternalTransferService externalTransferService;

    public static DataBinder<ExternalTransferQuery> externalTransferQueryDataBinder(LocalSettings localSettings) {
        BeanBinder<ExternalTransferQuery> binder = BeanBinder.instance(ExternalTransferQuery.class);
        binder.registerBinder("account", PropertyBinder.instance(ExternalAccount.class, "account", ReferenceConverter.instance(ExternalAccount.class)));
        binder.registerBinder("type", PropertyBinder.instance(ExternalTransferType.class, "type", ReferenceConverter.instance(ExternalTransferType.class)));
        binder.registerBinder("transferImport", PropertyBinder.instance(ExternalTransferImport.class, "transferImport", ReferenceConverter.instance(ExternalTransferImport.class)));
        binder.registerBinder("status", PropertyBinder.instance(ExternalTransfer.SummaryStatus.class, "status"));
        binder.registerBinder("member", PropertyBinder.instance(Member.class, "member", ReferenceConverter.instance(Member.class)));
        binder.registerBinder("initialAmount", PropertyBinder.instance(BigDecimal.class, "initialAmount"));
        binder.registerBinder("finalAmount", PropertyBinder.instance(BigDecimal.class, "finalAmount"));
        binder.registerBinder("period", DataBinderHelper.periodBinder(localSettings, "period"));
        binder.registerBinder("pageParameters", DataBinderHelper.pageBinder());
        return binder;
    }

    public DataBinder<ExternalTransferQuery> getDataBinder() {
        if (this.dataBinder == null) {
            LocalSettings localSettings = this.settingsService.getLocalSettings();
            this.dataBinder = ExternalAccountHistoryAction.externalTransferQueryDataBinder(localSettings);
        }
        return this.dataBinder;
    }

    @Override
    public void onLocalSettingsUpdate(LocalSettingsEvent event) {
        super.onLocalSettingsUpdate(event);
        this.dataBinder = null;
    }

    @Inject
    public void setExternalAccountService(ExternalAccountService externalAccountService) {
        this.externalAccountService = externalAccountService;
    }

    @Inject
    public void setExternalTransferImportService(ExternalTransferImportService externalTransferImportService) {
        this.externalTransferImportService = externalTransferImportService;
    }

    @Inject
    public void setExternalTransferService(ExternalTransferService externalTransferService) {
        this.externalTransferService = externalTransferService;
    }

    @Override
    protected void executeQuery(ActionContext context, QueryParameters queryParameters) {
        HttpServletRequest request = context.getRequest();
        ExternalTransferQuery query = (ExternalTransferQuery)queryParameters;
        List<ExternalTransfer> externalTransfers = this.externalTransferService.search(query);
        request.setAttribute("externalTransfers", externalTransfers);
        request.setAttribute("summary", this.processSummary(externalTransfers));
    }

    @Override
    protected QueryParameters prepareForm(ActionContext context) {
        HttpServletRequest request = context.getRequest();
        ExternalAccountHistoryForm form = (ExternalAccountHistoryForm)((Object)context.getForm());
        ExternalTransferQuery query = this.getDataBinder().readFromString(form.getQuery());
        query.fetch(ExternalTransfer.Relationships.TRANSFER_IMPORT, ExternalTransfer.Relationships.TYPE);
        ExternalAccount externalAccount = null;
        Long transferImportId = form.getTransferImportId();
        if (transferImportId != null && transferImportId > 0L) {
            ExternalTransferImport transferImport = this.externalTransferImportService.load(transferImportId, RelationshipHelper.nested(ExternalTransferImport.Relationships.ACCOUNT, ExternalAccount.Relationships.TYPES));
            query.setTransferImport(transferImport);
            externalAccount = transferImport.getAccount();
            request.setAttribute("transferImport", (Object)transferImport);
        } else {
            Long externalAccountId = form.getExternalAccountId();
            if (externalAccountId == null) {
                throw new ValidationException();
            }
            externalAccount = this.externalAccountService.load(externalAccountId, ExternalAccount.Relationships.TYPES);
        }
        query.setAccount(externalAccount);
        Collection<ExternalTransferType> types = externalAccount.getTypes();
        boolean process = this.permissionService.hasPermission(AdminSystemPermission.EXTERNAL_ACCOUNTS_PROCESS_PAYMENT);
        boolean check = this.permissionService.hasPermission(AdminSystemPermission.EXTERNAL_ACCOUNTS_CHECK_PAYMENT);
        boolean managePayment = this.permissionService.hasPermission(AdminSystemPermission.EXTERNAL_ACCOUNTS_MANAGE_PAYMENT);
        request.setAttribute("isProcess", (Object)process);
        request.setAttribute("isManage", (Object)managePayment);
        request.setAttribute("isCheck", (Object)check);
        request.setAttribute("externalAccount", (Object)externalAccount);
        request.setAttribute("types", types);
        RequestHelper.storeEnum(request, ExternalTransfer.SummaryStatus.class, "statusList");
        ArrayList<ExternalTransferAction> listPossibleActions = new ArrayList<ExternalTransferAction>();
        if (check) {
            listPossibleActions.add(ExternalTransferAction.MARK_AS_CHECKED);
            listPossibleActions.add(ExternalTransferAction.MARK_AS_UNCHECKED);
        }
        if (managePayment) {
            listPossibleActions.add(ExternalTransferAction.DELETE);
        }
        request.setAttribute("possibleActions", listPossibleActions);
        this.getDataBinder().writeAsString(form.getQuery(), query);
        return query;
    }

    @Override
    protected boolean willExecuteQuery(ActionContext context, QueryParameters queryParameters) throws Exception {
        return true;
    }

    private Map<ExternalTransfer.SummaryStatus, TransactionSummaryVO> processSummary(List<ExternalTransfer> externalTransfers) {
        EnumMap<ExternalTransfer.SummaryStatus, TransactionSummaryVO> summary = new EnumMap<ExternalTransfer.SummaryStatus, TransactionSummaryVO>(ExternalTransfer.SummaryStatus.class);
        for (ExternalTransfer.SummaryStatus summaryStatus : ExternalTransfer.SummaryStatus.values()) {
            summary.put(summaryStatus, new NegativeAllowedTransactionSummaryVO(0, new BigDecimal(0)));
        }
        TransactionSummaryVO totalVo = (TransactionSummaryVO)summary.get((Object)ExternalTransfer.SummaryStatus.TOTAL);
        for (ExternalTransfer transfer : externalTransfers) {
            ExternalTransfer.Status status = transfer.getStatus();
            TransactionSummaryVO vo = null;
            switch (status) {
                case PENDING: {
                    if (transfer.isComplete()) {
                        vo = (TransactionSummaryVO)summary.get((Object)ExternalTransfer.SummaryStatus.COMPLETE_PENDING);
                        break;
                    }
                    vo = (TransactionSummaryVO)summary.get((Object)ExternalTransfer.SummaryStatus.INCOMPLETE_PENDING);
                    break;
                }
                case CHECKED: {
                    vo = (TransactionSummaryVO)summary.get((Object)ExternalTransfer.SummaryStatus.CHECKED);
                    break;
                }
                case PROCESSED: {
                    vo = (TransactionSummaryVO)summary.get((Object)ExternalTransfer.SummaryStatus.PROCESSED);
                }
            }
            BigDecimal amount = BigDecimalHelper.nvl(transfer.getAmount());
            vo.setCount(vo.getCount() + 1);
            vo.setAmount(vo.getAmount().add(amount));
            totalVo.setCount(totalVo.getCount() + 1);
            totalVo.setAmount(totalVo.getAmount().add(amount));
        }
        return summary;
    }
}

