/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.accounts.external;

import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseAction;
import nl.strohalm.cyclos.controls.accounts.external.RemoveExternalAccountForm;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.accounts.external.ExternalAccountService;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.struts.action.ActionForward;

public class RemoveExternalAccountAction
extends BaseAction {
    private ExternalAccountService externalAccountService;

    @Inject
    public void setExternalAccountService(ExternalAccountService externalAccountService) {
        this.externalAccountService = externalAccountService;
    }

    @Override
    protected ActionForward executeAction(ActionContext context) throws Exception {
        RemoveExternalAccountForm form = (RemoveExternalAccountForm)((Object)context.getForm());
        long id = form.getExternalAccountId();
        if (id <= 0L) {
            throw new ValidationException();
        }
        try {
            this.externalAccountService.remove(id);
            context.sendMessage("externalAccount.removed", new Object[0]);
        }
        catch (PermissionDeniedException e) {
            throw e;
        }
        catch (Exception e) {
            context.sendMessage("externalAccount.error.removing", new Object[0]);
        }
        return context.getSuccessForward();
    }
}

