/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.accounts.external;

import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseAction;
import nl.strohalm.cyclos.controls.accounts.external.RemoveExternalTransferTypeForm;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.external.ExternalTransferType;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.accounts.external.ExternalTransferTypeService;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.struts.action.ActionForward;

public class RemoveExternalTransferTypeAction
extends BaseAction {
    private ExternalTransferTypeService externalTransferTypeService;

    @Inject
    public void setExternalTransferTypeService(ExternalTransferTypeService externalTransferTypeService) {
        this.externalTransferTypeService = externalTransferTypeService;
    }

    @Override
    protected ActionForward executeAction(ActionContext context) throws Exception {
        RemoveExternalTransferTypeForm form = (RemoveExternalTransferTypeForm)((Object)context.getForm());
        long id = form.getExternalTransferTypeId();
        if (id <= 0L) {
            throw new ValidationException();
        }
        ExternalTransferType transferType = this.externalTransferTypeService.load(id, new Relationship[0]);
        try {
            this.externalTransferTypeService.remove(id);
            context.sendMessage("externalTransferType.removed", new Object[0]);
        }
        catch (PermissionDeniedException e) {
            throw e;
        }
        catch (Exception e) {
            context.sendMessage("externalTransferType.error.removing", new Object[0]);
        }
        return ActionHelper.redirectWithParam(context.getRequest(), context.getSuccessForward(), "externalAccountId", transferType.getAccount().getId());
    }
}

