/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.accounts.external.externaltransfers;

import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseAction;
import nl.strohalm.cyclos.controls.accounts.external.externaltransfers.ChangeExternalTransferForm;
import nl.strohalm.cyclos.entities.accounts.external.ExternalTransferAction;
import nl.strohalm.cyclos.services.accounts.external.ExternalTransferService;
import nl.strohalm.cyclos.services.accounts.external.exceptions.CannotDeleteExternalTransferException;
import nl.strohalm.cyclos.services.accounts.external.exceptions.CannotMarkExternalTransferAsCheckedException;
import nl.strohalm.cyclos.services.accounts.external.exceptions.CannotMarkExternalTransferAsUncheckedException;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.conversion.CoercionHelper;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.struts.action.ActionForward;

public class ChangeExternalTransferAction
extends BaseAction {
    private ExternalTransferService externalTransferService;

    @Inject
    public void setExternalTransferService(ExternalTransferService externalTransferService) {
        this.externalTransferService = externalTransferService;
    }

    @Override
    protected ActionForward executeAction(ActionContext context) throws Exception {
        ChangeExternalTransferForm form = (ChangeExternalTransferForm)((Object)context.getForm());
        ExternalTransferAction action = CoercionHelper.coerce(ExternalTransferAction.class, form.getAction());
        Long[] ids = form.getExternalTransferId();
        if (action == null || ids == null || ids.length == 0) {
            throw new ValidationException();
        }
        try {
            this.externalTransferService.performAction(action, ids);
        }
        catch (CannotDeleteExternalTransferException e) {
            return context.sendError("externalAccountHistory.error.cannotDeleteExternalTransfer", new Object[0]);
        }
        catch (CannotMarkExternalTransferAsCheckedException e) {
            return context.sendError("externalAccountHistory.error.cannotMarkExternalTransferAsChecked", new Object[0]);
        }
        catch (CannotMarkExternalTransferAsUncheckedException e) {
            return context.sendError("externalAccountHistory.error.cannotMarkExternalTransferAsUnchecked", new Object[0]);
        }
        if (action == ExternalTransferAction.DELETE) {
            context.sendMessage("externalTransfer.removed", new Object[0]);
        }
        long transferImportId = form.getTransferImportId();
        long externalAccountId = form.getExternalAccountId();
        String paramName = null;
        long paramValue = 0L;
        if (transferImportId > 0L) {
            paramName = "transferImportId";
            paramValue = transferImportId;
        } else {
            paramName = "externalAccountId";
            paramValue = externalAccountId;
        }
        return ActionHelper.redirectWithParam(context.getRequest(), context.getSuccessForward(), paramName, paramValue);
    }
}

