/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.accounts.external.externaltransfers;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.EnumSet;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.access.AdminSystemPermission;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.accounts.external.externaltransfers.EditExternalTransferForm;
import nl.strohalm.cyclos.entities.accounts.external.ExternalAccount;
import nl.strohalm.cyclos.entities.accounts.external.ExternalTransfer;
import nl.strohalm.cyclos.entities.accounts.external.ExternalTransferImport;
import nl.strohalm.cyclos.entities.accounts.external.ExternalTransferType;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsChangeListener;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsEvent;
import nl.strohalm.cyclos.services.accounts.external.ExternalAccountService;
import nl.strohalm.cyclos.services.accounts.external.ExternalTransferService;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.conversion.IdConverter;
import nl.strohalm.cyclos.utils.conversion.ReferenceConverter;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.struts.action.ActionForward;

public class EditExternalTransferAction
extends BaseFormAction
implements LocalSettingsChangeListener {
    private ExternalAccountService externalAccountService;
    private ExternalTransferService externalTransferService;
    private DataBinder<ExternalTransfer> dataBinder;

    public DataBinder<ExternalTransfer> getDataBinder() {
        if (this.dataBinder == null) {
            LocalSettings localSettings = this.settingsService.getLocalSettings();
            BeanBinder<ExternalTransfer> externalTransferBinder = BeanBinder.instance(ExternalTransfer.class);
            externalTransferBinder.registerBinder("id", PropertyBinder.instance(Long.class, "id", IdConverter.instance()));
            externalTransferBinder.registerBinder("account", PropertyBinder.instance(ExternalAccount.class, "account", ReferenceConverter.instance(ExternalAccount.class)));
            externalTransferBinder.registerBinder("transferImport", PropertyBinder.instance(ExternalTransferImport.class, "transferImport", ReferenceConverter.instance(ExternalTransferImport.class)));
            externalTransferBinder.registerBinder("type", PropertyBinder.instance(ExternalTransferType.class, "type", ReferenceConverter.instance(ExternalTransferType.class)));
            externalTransferBinder.registerBinder("date", PropertyBinder.instance(Calendar.class, "date", localSettings.getRawDateConverter()));
            externalTransferBinder.registerBinder("amount", PropertyBinder.instance(BigDecimal.class, "amount", localSettings.getNumberConverter()));
            externalTransferBinder.registerBinder("member", PropertyBinder.instance(Member.class, "member", ReferenceConverter.instance(Member.class)));
            externalTransferBinder.registerBinder("description", PropertyBinder.instance(String.class, "description"));
            this.dataBinder = externalTransferBinder;
        }
        return this.dataBinder;
    }

    @Override
    public void onLocalSettingsUpdate(LocalSettingsEvent event) {
        this.dataBinder = null;
    }

    @Inject
    public void setExternalAccountService(ExternalAccountService externalAccountService) {
        this.externalAccountService = externalAccountService;
    }

    @Inject
    public void setExternalTransferService(ExternalTransferService externalTransferService) {
        this.externalTransferService = externalTransferService;
    }

    @Override
    protected ActionForward handleSubmit(ActionContext context) throws Exception {
        EditExternalTransferForm form = (EditExternalTransferForm)((Object)context.getForm());
        ExternalTransfer externalTransfer = this.readExternalTransfer(context);
        boolean isInsert = externalTransfer.isTransient();
        externalTransfer = this.externalTransferService.save(externalTransfer);
        context.sendMessage(isInsert ? "externalTransfer.inserted" : "externalTransfer.modified", new Object[0]);
        long transferImportId = form.getTransferImportId();
        long externalAccountId = form.getExternalAccountId();
        String paramName = null;
        long paramValue = 0L;
        if (transferImportId > 0L) {
            paramName = "transferImportId";
            paramValue = transferImportId;
        } else {
            paramName = "externalAccountId";
            paramValue = externalAccountId;
        }
        return ActionHelper.redirectWithParam(context.getRequest(), context.getSuccessForward(), paramName, paramValue);
    }

    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        HttpServletRequest request = context.getRequest();
        EditExternalTransferForm form = (EditExternalTransferForm)((Object)context.getForm());
        long externalAccountId = form.getExternalAccountId();
        if (externalAccountId <= 0L) {
            throw new ValidationException();
        }
        ExternalAccount externalAccount = this.externalAccountService.load(externalAccountId, ExternalAccount.Relationships.TYPES);
        request.setAttribute("externalAccount", (Object)externalAccount);
        long transferImportId = form.getTransferImportId();
        request.setAttribute("transferImportId", (Object)transferImportId);
        long externalTransferId = form.getExternalTransferId();
        boolean isInsert = externalTransferId <= 0L;
        ExternalTransfer externalTransfer = null;
        externalTransfer = isInsert ? new ExternalTransfer() : this.externalTransferService.load(externalTransferId, ExternalTransfer.Relationships.TRANSFER_IMPORT, ExternalTransfer.Relationships.TYPE, ExternalTransfer.Relationships.MEMBER);
        this.getDataBinder().writeAsString(form.getExternalTransfer(), externalTransfer);
        boolean editable = this.permissionService.hasPermission(AdminSystemPermission.EXTERNAL_ACCOUNTS_MANAGE_PAYMENT) && externalTransfer.getStatus() == ExternalTransfer.Status.PENDING;
        request.setAttribute("externalTransfer", (Object)externalTransfer);
        request.setAttribute("editable", (Object)editable);
        request.setAttribute("isInsert", (Object)isInsert);
        request.setAttribute("statusList", EnumSet.of(ExternalTransfer.Status.PENDING, ExternalTransfer.Status.CHECKED));
    }

    @Override
    protected void validateForm(ActionContext context) {
        ExternalTransfer externalTransfer = this.readExternalTransfer(context);
        this.externalTransferService.validate(externalTransfer);
    }

    private ExternalTransfer readExternalTransfer(ActionContext context) {
        EditExternalTransferForm form = (EditExternalTransferForm)((Object)context.getForm());
        return this.getDataBinder().readFromString(form.getExternalTransfer());
    }
}

