/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.accounts.external.filemappings;

import java.util.EnumSet;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.access.AdminSystemPermission;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.accounts.external.filemappings.EditFieldMappingForm;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.MemberAccountType;
import nl.strohalm.cyclos.entities.accounts.external.ExternalAccount;
import nl.strohalm.cyclos.entities.accounts.external.filemapping.FieldMapping;
import nl.strohalm.cyclos.entities.accounts.external.filemapping.FileMapping;
import nl.strohalm.cyclos.entities.accounts.external.filemapping.FileMappingWithFields;
import nl.strohalm.cyclos.entities.customization.fields.MemberCustomField;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.GroupQuery;
import nl.strohalm.cyclos.services.accounts.external.filemapping.FieldMappingService;
import nl.strohalm.cyclos.services.accounts.external.filemapping.FileMappingService;
import nl.strohalm.cyclos.services.customization.MemberCustomFieldService;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.CustomFieldHelper;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.RequestHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.conversion.IdConverter;
import nl.strohalm.cyclos.utils.conversion.ReferenceConverter;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.struts.action.ActionForward;

public class EditFieldMappingAction
extends BaseFormAction {
    private MemberCustomFieldService memberCustomFieldService;
    private FieldMappingService fieldMappingService;
    private FileMappingService fileMappingService;
    private DataBinder<FieldMapping> dataBinder;
    private CustomFieldHelper customFieldHelper;

    public DataBinder<FieldMapping> getDataBinder() {
        if (this.dataBinder == null) {
            BeanBinder<FieldMapping> fieldMappingBinder = BeanBinder.instance(FieldMapping.class);
            fieldMappingBinder.registerBinder("id", PropertyBinder.instance(Long.class, "id", IdConverter.instance()));
            fieldMappingBinder.registerBinder("fileMapping", PropertyBinder.instance(FileMapping.class, "fileMapping", ReferenceConverter.instance(FileMapping.class)));
            fieldMappingBinder.registerBinder("order", PropertyBinder.instance(Integer.TYPE, "order"));
            fieldMappingBinder.registerBinder("name", PropertyBinder.instance(String.class, "name"));
            fieldMappingBinder.registerBinder("field", PropertyBinder.instance(FieldMapping.Field.class, "field"));
            fieldMappingBinder.registerBinder("memberField", PropertyBinder.instance(MemberCustomField.class, "memberField", ReferenceConverter.instance(MemberCustomField.class)));
            this.dataBinder = fieldMappingBinder;
        }
        return this.dataBinder;
    }

    @Inject
    public void setCustomFieldHelper(CustomFieldHelper customFieldHelper) {
        this.customFieldHelper = customFieldHelper;
    }

    @Inject
    public void setFieldMappingService(FieldMappingService fieldMappingService) {
        this.fieldMappingService = fieldMappingService;
    }

    @Inject
    public void setFileMappingService(FileMappingService fileMappingService) {
        this.fileMappingService = fileMappingService;
    }

    @Inject
    public void setMemberCustomFieldService(MemberCustomFieldService memberCustomFieldService) {
        this.memberCustomFieldService = memberCustomFieldService;
    }

    @Override
    protected ActionForward handleSubmit(ActionContext context) throws Exception {
        EditFieldMappingForm form = (EditFieldMappingForm)((Object)context.getForm());
        FieldMapping fieldMapping = this.getDataBinder().readFromString(form.getFieldMapping());
        boolean isInsert = fieldMapping.isTransient();
        fieldMapping = this.fieldMappingService.save(fieldMapping);
        context.sendMessage(isInsert ? "fieldMapping.inserted" : "fieldMapping.modified", new Object[0]);
        Long externalAccountId = fieldMapping.getFileMapping().getAccount().getId();
        return ActionHelper.redirectWithParam(context.getRequest(), context.getSuccessForward(), "externalAccountId", externalAccountId);
    }

    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        HttpServletRequest request = context.getRequest();
        EditFieldMappingForm form = (EditFieldMappingForm)((Object)context.getForm());
        Long fileMappingId = form.getFileMappingId();
        if (fileMappingId <= 0L) {
            throw new ValidationException();
        }
        FileMapping fileMapping = this.fileMappingService.load(fileMappingId, FileMappingWithFields.Relationships.FIELDS, RelationshipHelper.nested(FileMapping.Relationships.EXTERNAL_ACCOUNT, ExternalAccount.Relationships.MEMBER_ACCOUNT_TYPE));
        MemberAccountType memberAccountType = fileMapping.getAccount().getMemberAccountType();
        long fieldMappingId = form.getFieldMappingId();
        boolean isInsert = fieldMappingId <= 0L;
        FieldMapping fieldMapping = null;
        if (isInsert) {
            fieldMapping = new FieldMapping();
            fieldMapping.setFileMapping(fileMapping);
        } else {
            fieldMapping = this.fieldMappingService.load(fieldMappingId, new Relationship[0]);
        }
        this.getDataBinder().writeAsString(form.getFieldMapping(), fieldMapping);
        request.setAttribute("fieldMapping", (Object)fieldMapping);
        request.setAttribute("editable", (Object)this.permissionService.hasPermission(AdminSystemPermission.EXTERNAL_ACCOUNTS_MANAGE));
        request.setAttribute("isInsert", (Object)isInsert);
        RequestHelper.storeEnum(request, FileMappingWithFields.NumberFormat.class, "numberFormats");
        EnumSet<FieldMapping.Field> fields = EnumSet.allOf(FieldMapping.Field.class);
        EnumSet<FieldMapping.Field> memberIdentificationFields = EnumSet.of(FieldMapping.Field.MEMBER_ID, FieldMapping.Field.MEMBER_USERNAME, FieldMapping.Field.MEMBER_CUSTOM_FIELD);
        if (fileMapping instanceof FileMappingWithFields) {
            FileMappingWithFields fileWithFields = (FileMappingWithFields)fileMapping;
            for (FieldMapping current : fileWithFields.getFields()) {
                FieldMapping.Field field = current.getField();
                if (field == FieldMapping.Field.IGNORED) continue;
                if (memberIdentificationFields.contains(field) && !memberIdentificationFields.contains(fieldMapping.getField())) {
                    fields.removeAll(memberIdentificationFields);
                    continue;
                }
                fields.remove(field);
            }
            if (!isInsert) {
                fields.add(fieldMapping.getField());
            }
        }
        request.setAttribute("fields", fields);
        if (fields.contains(FieldMapping.Field.MEMBER_CUSTOM_FIELD)) {
            List<MemberCustomField> memberCustomFields = this.getMemberCustomFields(memberAccountType);
            request.setAttribute("memberFields", memberCustomFields);
        }
    }

    @Override
    protected void validateForm(ActionContext context) {
        EditFieldMappingForm form = (EditFieldMappingForm)((Object)context.getForm());
        FieldMapping fieldMapping = this.getDataBinder().readFromString(form.getFieldMapping());
        this.fieldMappingService.validate(fieldMapping);
    }

    private List<MemberCustomField> getMemberCustomFields(MemberAccountType memberAccountType) {
        GroupQuery groupQuery = new GroupQuery();
        groupQuery.setMemberAccountType(memberAccountType);
        List<? extends Group> memberGroups = this.groupService.search(groupQuery);
        List<MemberCustomField> memberFields = this.memberCustomFieldService.list();
        memberFields = this.customFieldHelper.onlyForGroups(memberFields, memberGroups);
        return memberFields;
    }
}

