/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.accounts.external.filemappings;

import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.access.AdminSystemPermission;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.accounts.external.filemappings.EditFileMappingForm;
import nl.strohalm.cyclos.entities.accounts.external.ExternalAccount;
import nl.strohalm.cyclos.entities.accounts.external.filemapping.CSVFileMapping;
import nl.strohalm.cyclos.entities.accounts.external.filemapping.CustomFileMapping;
import nl.strohalm.cyclos.entities.accounts.external.filemapping.FieldMapping;
import nl.strohalm.cyclos.entities.accounts.external.filemapping.FileMapping;
import nl.strohalm.cyclos.entities.accounts.external.filemapping.FileMappingWithFields;
import nl.strohalm.cyclos.services.accounts.external.ExternalAccountService;
import nl.strohalm.cyclos.services.accounts.external.filemapping.FileMappingService;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.RequestHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.conversion.IdConverter;
import nl.strohalm.cyclos.utils.conversion.ReferenceConverter;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.struts.action.ActionForward;

public class EditFileMappingAction
extends BaseFormAction {
    private ExternalAccountService externalAccountService;
    private FileMappingService fileMappingService;
    private Map<FileMapping.Nature, DataBinder<? extends FileMapping>> dataBinders;

    public DataBinder<? extends FileMapping> getDataBinder(FileMapping.Nature nature) {
        if (this.dataBinders == null) {
            this.dataBinders = new EnumMap<FileMapping.Nature, DataBinder<? extends FileMapping>>(FileMapping.Nature.class);
            BeanBinder<CSVFileMapping> csvFileMappingBinder = BeanBinder.instance(CSVFileMapping.class);
            this.initBasicFileMapping(csvFileMappingBinder);
            this.initFileMappingWithFields(csvFileMappingBinder);
            csvFileMappingBinder.registerBinder("stringQuote", PropertyBinder.instance(Character.class, "stringQuote"));
            csvFileMappingBinder.registerBinder("columnSeparator", PropertyBinder.instance(Character.class, "columnSeparator"));
            csvFileMappingBinder.registerBinder("headerLines", PropertyBinder.instance(Integer.class, "headerLines"));
            this.dataBinders.put(FileMapping.Nature.CSV, csvFileMappingBinder);
            BeanBinder<CustomFileMapping> customFileMappingBinder = BeanBinder.instance(CustomFileMapping.class);
            this.initBasicFileMapping(customFileMappingBinder);
            customFileMappingBinder.registerBinder("className", PropertyBinder.instance(String.class, "className"));
            this.dataBinders.put(FileMapping.Nature.CUSTOM, customFileMappingBinder);
        }
        return this.dataBinders.get((Object)nature);
    }

    @Inject
    public void setExternalAccountService(ExternalAccountService externalAccountService) {
        this.externalAccountService = externalAccountService;
    }

    @Inject
    public void setFileMappingService(FileMappingService fileMappingService) {
        this.fileMappingService = fileMappingService;
    }

    @Override
    protected ActionForward handleSubmit(ActionContext context) throws Exception {
        FileMapping fileMapping = this.resolveFileMapping(context);
        boolean isInsert = fileMapping.isTransient();
        this.fileMappingService.save(fileMapping);
        context.sendMessage(isInsert ? "fileMapping.inserted" : "fileMapping.modified", new Object[0]);
        return ActionHelper.redirectWithParam(context.getRequest(), context.getSuccessForward(), "externalAccountId", fileMapping.getAccount().getId());
    }

    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        boolean isInsert;
        HttpServletRequest request = context.getRequest();
        EditFileMappingForm form = (EditFileMappingForm)((Object)context.getForm());
        long externalAccountId = form.getExternalAccountId();
        if (externalAccountId <= 0L) {
            throw new ValidationException();
        }
        ExternalAccount externalAccount = this.externalAccountService.load(externalAccountId, RelationshipHelper.nested(ExternalAccount.Relationships.FILE_MAPPING, FileMappingWithFields.Relationships.FIELDS));
        FileMapping fileMapping = externalAccount.getFileMapping();
        boolean bl = isInsert = fileMapping == null;
        if (!isInsert) {
            DataBinder<? extends FileMapping> dataBinder = this.getDataBinder(fileMapping.getNature());
            dataBinder.writeAsString(form.getFileMapping(), fileMapping);
            request.setAttribute("fileMapping", (Object)fileMapping);
            if (fileMapping instanceof FileMappingWithFields) {
                FileMappingWithFields fmWithFields = (FileMappingWithFields)fileMapping;
                Collection<FieldMapping> fieldMappings = fmWithFields.getFields();
                request.setAttribute("fieldMappings", fieldMappings);
            }
        } else {
            form.setFileMapping("columnSeparator", CSVFileMapping.DEFAULT_COLUMN_SEPARATOR);
            form.setFileMapping("stringQuote", CSVFileMapping.DEFAULT_STRING_QUOTE);
            form.setFileMapping("headerLines", CSVFileMapping.DEFAULT_HEADER_LINES);
            form.setFileMapping("dateFormat", "yyyy-MM-dd");
            form.setFileMapping("numberFormat", FileMappingWithFields.DEFAULT_NUMBER_FORMAT);
            form.setFileMapping("decimalPlaces", FileMappingWithFields.DEFAULT_DECIMAL_PLACES);
            form.setFileMapping("decimalSeparator", FileMappingWithFields.DEFAULT_DECIMAL_SEPARATOR);
            form.setFileMapping("negativeAmountValue", FileMappingWithFields.DEFAULT_NEGATIVE_AMOUNT_VALUE);
        }
        boolean editable = this.permissionService.hasPermission(AdminSystemPermission.EXTERNAL_ACCOUNTS_MANAGE);
        form.setFileMapping("account", externalAccount.getId());
        request.setAttribute("externalAccountId", (Object)externalAccount.getId());
        request.setAttribute("editable", (Object)editable);
        request.setAttribute("isInsert", (Object)isInsert);
        RequestHelper.storeEnum(request, FileMapping.Nature.class, "natures");
        RequestHelper.storeEnum(request, FileMappingWithFields.NumberFormat.class, "numberFormats");
    }

    @Override
    protected void validateForm(ActionContext context) {
        FileMapping fileMapping = this.resolveFileMapping(context);
        this.fileMappingService.validate(fileMapping);
    }

    private void initBasicFileMapping(BeanBinder<? extends FileMapping> fileMappingBinder) {
        fileMappingBinder.registerBinder("id", PropertyBinder.instance(Long.class, "id", IdConverter.instance()));
        fileMappingBinder.registerBinder("account", PropertyBinder.instance(ExternalAccount.class, "account", ReferenceConverter.instance(ExternalAccount.class)));
    }

    private void initFileMappingWithFields(BeanBinder<? extends FileMappingWithFields> fileMappingWithFieldsBinder) {
        fileMappingWithFieldsBinder.registerBinder("numberFormat", PropertyBinder.instance(FileMappingWithFields.NumberFormat.class, "numberFormat"));
        fileMappingWithFieldsBinder.registerBinder("decimalPlaces", PropertyBinder.instance(Integer.class, "decimalPlaces"));
        fileMappingWithFieldsBinder.registerBinder("decimalSeparator", PropertyBinder.instance(Character.class, "decimalSeparator"));
        fileMappingWithFieldsBinder.registerBinder("negativeAmountValue", PropertyBinder.instance(String.class, "negativeAmountValue"));
        fileMappingWithFieldsBinder.registerBinder("dateFormat", PropertyBinder.instance(String.class, "dateFormat"));
    }

    private FileMapping resolveFileMapping(ActionContext context) {
        EditFileMappingForm form = (EditFileMappingForm)((Object)context.getForm());
        FileMapping.Nature nature = null;
        String fileMappingNature = (String)form.getFileMapping("nature");
        nature = "CSV".equals(fileMappingNature) ? FileMapping.Nature.CSV : FileMapping.Nature.CUSTOM;
        return this.getDataBinder(nature).readFromString(form.getFileMapping());
    }
}

