/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.accounts.external.filemappings;

import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.accounts.external.filemappings.SetFieldMappingsOrderForm;
import nl.strohalm.cyclos.entities.accounts.external.filemapping.FileMapping;
import nl.strohalm.cyclos.entities.accounts.external.filemapping.FileMappingWithFields;
import nl.strohalm.cyclos.services.accounts.external.filemapping.FieldMappingService;
import nl.strohalm.cyclos.services.accounts.external.filemapping.FileMappingService;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.struts.action.ActionForward;

public class SetFieldMappingsOrderAction
extends BaseFormAction {
    private FieldMappingService fieldMappingService;
    private FileMappingService fileMappingService;

    @Inject
    public void setFieldMappingService(FieldMappingService fieldMappingService) {
        this.fieldMappingService = fieldMappingService;
    }

    @Inject
    public void setFileMappingService(FileMappingService fileMappingService) {
        this.fileMappingService = fileMappingService;
    }

    @Override
    protected ActionForward handleSubmit(ActionContext context) throws Exception {
        SetFieldMappingsOrderForm form = (SetFieldMappingsOrderForm)((Object)context.getForm());
        long fileMappingId = form.getFileMappingId();
        FileMapping fileMapping = this.fileMappingService.load(fileMappingId, FileMapping.Relationships.EXTERNAL_ACCOUNT);
        Long externalAccountId = fileMapping.getAccount().getId();
        this.fieldMappingService.setOrder(form.getFieldsIds());
        context.sendMessage("fieldMapping.orderModified", new Object[0]);
        return ActionHelper.redirectWithParam(context.getRequest(), context.getSuccessForward(), "externalAccountId", externalAccountId);
    }

    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        HttpServletRequest request = context.getRequest();
        SetFieldMappingsOrderForm form = (SetFieldMappingsOrderForm)((Object)context.getForm());
        long fileMappingId = form.getFileMappingId();
        if (fileMappingId <= 0L) {
            throw new ValidationException();
        }
        FileMappingWithFields fileMapping = (FileMappingWithFields)this.fileMappingService.load(fileMappingId, FileMappingWithFields.Relationships.FIELDS);
        request.setAttribute("fieldMappings", fileMapping.getFields());
        request.setAttribute("fileMappingId", (Object)fileMappingId);
    }
}

