/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.accounts.external.process;

import java.util.Iterator;
import java.util.List;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.accounts.external.process.ExternalTransferToProcessVO;
import nl.strohalm.cyclos.entities.accounts.SystemAccountOwner;
import nl.strohalm.cyclos.entities.accounts.external.ExternalAccount;
import nl.strohalm.cyclos.entities.accounts.external.ExternalTransfer;
import nl.strohalm.cyclos.entities.accounts.loans.Loan;
import nl.strohalm.cyclos.entities.accounts.loans.LoanQuery;
import nl.strohalm.cyclos.entities.accounts.transactions.Transfer;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferQuery;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.services.transactions.LoanService;
import nl.strohalm.cyclos.services.transactions.PaymentService;

public class ExternalTransferToProcessVOIterator
implements Iterator<ExternalTransferToProcessVO> {
    private final Iterator<ExternalTransfer> externalTransferVOs;
    private PaymentService paymentService;
    private LoanService loanService;
    private final ExternalAccount externalAccount;

    public ExternalTransferToProcessVOIterator(Iterator<ExternalTransfer> iterator, ExternalAccount externalAccount) {
        this.externalTransferVOs = iterator;
        this.externalAccount = externalAccount;
    }

    @Override
    public boolean hasNext() {
        return this.externalTransferVOs.hasNext();
    }

    @Override
    public ExternalTransferToProcessVO next() {
        ExternalTransfer transfer = this.externalTransferVOs.next();
        ExternalTransferToProcessVO vo = new ExternalTransferToProcessVO();
        vo.setTransfer(transfer);
        switch (transfer.getType().getAction()) {
            case CONCILIATE_PAYMENT: {
                vo.setTransfersToConciliate(this.resolveTransfers(transfer.getMember()));
                break;
            }
            case DISCARD_LOAN: {
                vo.setLoansToDiscard(this.resolveLoans(transfer.getMember()));
            }
        }
        return vo;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Inject
    public void setLoanService(LoanService loanService) {
        this.loanService = loanService;
    }

    @Inject
    public void setPaymentService(PaymentService paymentService) {
        this.paymentService = paymentService;
    }

    private List<Loan> resolveLoans(Member member) {
        LoanQuery query = new LoanQuery();
        query.fetch(Loan.Relationships.PAYMENTS);
        query.setStatus(Loan.Status.OPEN);
        query.setMember(member);
        return this.loanService.search(query);
    }

    private List<Transfer> resolveTransfers(Member member) {
        TransferQuery query = new TransferQuery();
        query.setOwner(member);
        query.setType(this.externalAccount.getMemberAccountType());
        query.setToAccountOwner(SystemAccountOwner.instance());
        query.setConciliated(false);
        query.setReverseOrder(true);
        return this.paymentService.search(query);
    }
}

