/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.accounts.external.process;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseAction;
import nl.strohalm.cyclos.controls.accounts.external.process.ProcessExternalTransfersForm;
import nl.strohalm.cyclos.entities.accounts.external.ExternalTransfer;
import nl.strohalm.cyclos.entities.accounts.loans.Loan;
import nl.strohalm.cyclos.entities.accounts.transactions.Transfer;
import nl.strohalm.cyclos.entities.exceptions.UnexpectedEntityException;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsChangeListener;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsEvent;
import nl.strohalm.cyclos.services.accounts.external.ExternalTransferService;
import nl.strohalm.cyclos.services.accounts.external.ProcessExternalTransferDTO;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.RequestHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.BeanCollectionBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.struts.action.ActionForward;

public class ProcessExternalTransfersAction
extends BaseAction
implements LocalSettingsChangeListener {
    private ExternalTransferService externalTransferService;
    private DataBinder<Collection<ProcessExternalTransferDTO>> transferBinder;

    public DataBinder<Collection<ProcessExternalTransferDTO>> getTransferBinder() {
        if (this.transferBinder == null) {
            LocalSettings settings = this.settingsService.getLocalSettings();
            BeanBinder<ProcessExternalTransferDTO> binder = BeanBinder.instance(ProcessExternalTransferDTO.class);
            binder.registerBinder("externalTransfer", PropertyBinder.instance(ExternalTransfer.class, "externalTransfer"));
            binder.registerBinder("date", PropertyBinder.instance(Calendar.class, "date", settings.getRawDateConverter()));
            binder.registerBinder("loan", PropertyBinder.instance(Loan.class, "loan"));
            binder.registerBinder("transfer", PropertyBinder.instance(Transfer.class, "transfer"));
            binder.registerBinder("amount", PropertyBinder.instance(BigDecimal.class, "amount", settings.getNumberConverter()));
            this.transferBinder = BeanCollectionBinder.instance(binder);
        }
        return this.transferBinder;
    }

    @Override
    public void onLocalSettingsUpdate(LocalSettingsEvent event) {
        this.transferBinder = null;
    }

    @Inject
    public void setExternalTransferService(ExternalTransferService externalTransferService) {
        this.externalTransferService = externalTransferService;
    }

    @Override
    protected ActionForward executeAction(ActionContext context) throws Exception {
        HttpServletRequest request = context.getRequest();
        if (!RequestHelper.isPost(request)) {
            throw new ValidationException();
        }
        ProcessExternalTransfersForm form = (ProcessExternalTransfersForm)((Object)context.getForm());
        Collection<ProcessExternalTransferDTO> transfers = this.getTransferBinder().readFromString((Object)form);
        try {
            this.externalTransferService.process(transfers);
        }
        catch (UnexpectedEntityException e) {
            throw new ValidationException();
        }
        context.sendMessage("externalTransferProcess.processed", new Object[0]);
        return ActionHelper.redirectWithParam(request, context.getSuccessForward(), "externalAccountId", form.getExternalAccountId());
    }
}

