/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.accounts.external.process;

import java.util.Calendar;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseQueryAction;
import nl.strohalm.cyclos.controls.accounts.external.ExternalAccountHistoryAction;
import nl.strohalm.cyclos.controls.accounts.external.process.ExternalTransferToProcessVOIterator;
import nl.strohalm.cyclos.controls.accounts.external.process.RetrieveTransfersToProcessForm;
import nl.strohalm.cyclos.entities.accounts.external.ExternalAccount;
import nl.strohalm.cyclos.entities.accounts.external.ExternalTransfer;
import nl.strohalm.cyclos.entities.accounts.external.ExternalTransferQuery;
import nl.strohalm.cyclos.entities.accounts.external.ExternalTransferType;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.services.accounts.external.ExternalAccountService;
import nl.strohalm.cyclos.services.accounts.external.ExternalTransferService;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.SpringHelper;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.query.QueryParameters;
import nl.strohalm.cyclos.utils.validation.ValidationException;

public class RetrieveTransfersToProcessAction
extends BaseQueryAction {
    private ExternalAccountService externalAccountService;
    private ExternalTransferService externalTransferService;
    private DataBinder<ExternalTransferQuery> dataBinder;

    public DataBinder<ExternalTransferQuery> getDataBinder() {
        if (this.dataBinder == null) {
            LocalSettings localSettings = this.settingsService.getLocalSettings();
            this.dataBinder = ExternalAccountHistoryAction.externalTransferQueryDataBinder(localSettings);
        }
        return this.dataBinder;
    }

    @Inject
    public void setExternalAccountService(ExternalAccountService externalAccountService) {
        this.externalAccountService = externalAccountService;
    }

    @Inject
    public void setExternalTransferService(ExternalTransferService externalTransferService) {
        this.externalTransferService = externalTransferService;
    }

    @Override
    protected void executeQuery(ActionContext context, QueryParameters queryParameters) {
        HttpServletRequest request = context.getRequest();
        ExternalAccount externalAccount = (ExternalAccount)request.getAttribute("externalAccount");
        ExternalTransferQuery query = (ExternalTransferQuery)queryParameters;
        query.setOnlyWithValidTypes(true);
        List<ExternalTransfer> externalTransfers = this.externalTransferService.search(query);
        ExternalTransferToProcessVOIterator voIterator = new ExternalTransferToProcessVOIterator(externalTransfers.iterator(), externalAccount);
        SpringHelper.injectBeans(this.getServlet().getServletContext(), (Object)voIterator);
        request.setAttribute("externalTransfers", (Object)voIterator);
    }

    @Override
    protected Integer pageSize(ActionContext context) {
        return null;
    }

    @Override
    protected QueryParameters prepareForm(ActionContext context) {
        RetrieveTransfersToProcessForm form = (RetrieveTransfersToProcessForm)((Object)context.getForm());
        Long externalAccountId = form.getExternalAccountId();
        if (externalAccountId == null || externalAccountId <= 0L) {
            throw new ValidationException();
        }
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        HttpServletRequest request = context.getRequest();
        ExternalAccount externalAccount = this.externalAccountService.load(externalAccountId, ExternalAccount.Relationships.MEMBER_ACCOUNT_TYPE, ExternalAccount.Relationships.SYSTEM_ACCOUNT_TYPE);
        request.setAttribute("externalAccount", (Object)externalAccount);
        request.setAttribute("canSetDate", (Object)this.permissionService.hasPermission(AdminMemberPermission.PAYMENTS_PAYMENT_WITH_DATE));
        request.setAttribute("today", (Object)localSettings.getDateConverter().toString(Calendar.getInstance()));
        ExternalTransferQuery query = this.getDataBinder().readFromString(form.getQuery());
        query.fetch(RelationshipHelper.nested(ExternalTransfer.Relationships.TYPE, ExternalTransferType.Relationships.TRANSFER_TYPE));
        query.fetch(RelationshipHelper.nested(ExternalTransfer.Relationships.MEMBER, Element.Relationships.USER));
        query.setAccount(externalAccount);
        query.setStatus(ExternalTransfer.SummaryStatus.CHECKED);
        return query;
    }

    @Override
    protected boolean willExecuteQuery(ActionContext context, QueryParameters queryParameters) throws Exception {
        return true;
    }
}

