/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.accounts.external.transferimports;

import java.io.InputStreamReader;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseAction;
import nl.strohalm.cyclos.controls.accounts.external.transferimports.NewTransferImportForm;
import nl.strohalm.cyclos.entities.accounts.external.ExternalAccount;
import nl.strohalm.cyclos.entities.accounts.external.ExternalTransferImport;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.services.accounts.external.ExternalAccountService;
import nl.strohalm.cyclos.services.accounts.external.ExternalTransferImportService;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.transactionimport.IllegalTransactionFileFormatException;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForward;
import org.apache.struts.upload.FormFile;

public class NewTransferImportAction
extends BaseAction {
    private ExternalAccountService externalAccountService;
    private ExternalTransferImportService externalTransferImportService;

    @Inject
    public void setExternalAccountService(ExternalAccountService externalAccountService) {
        this.externalAccountService = externalAccountService;
    }

    @Inject
    public void setExternalTransferImportService(ExternalTransferImportService externalTransferImportService) {
        this.externalTransferImportService = externalTransferImportService;
    }

    @Override
    protected ActionForward executeAction(ActionContext context) throws Exception {
        LocalSettings settings = this.settingsService.getLocalSettings();
        NewTransferImportForm form = (NewTransferImportForm)((Object)context.getForm());
        long externalAccountId = form.getExternalAccountId();
        if (externalAccountId <= 0L) {
            throw new ValidationException();
        }
        FormFile file = form.getFile();
        if (file == null || file.getFileSize() == 0) {
            throw new ValidationException();
        }
        ExternalAccount externalAccount = this.externalAccountService.load(externalAccountId, ExternalAccount.Relationships.FILE_MAPPING);
        try {
            InputStreamReader in = new InputStreamReader(file.getInputStream(), settings.getCharset());
            ExternalTransferImport transferImport = this.externalTransferImportService.importNew(externalAccount.getFileMapping(), in);
            context.sendMessage("externalTransferImport.imported", new Object[0]);
            return ActionHelper.redirectWithParam(context.getRequest(), context.getSuccessForward(), "transferImportId", transferImport.getId());
        }
        catch (IllegalTransactionFileFormatException e) {
            String message = e.getMessage();
            if (StringUtils.isEmpty((String)message)) {
                return context.sendError("externalTransferImport.error.format.detailed", e.getLine(), e.getColumn(), e.getField(), e.getValue());
            }
            return context.sendError("externalTransferImport.error.format.general", message);
        }
        catch (Exception e) {
            return context.sendError("externalTransferImport.error.importing", new Object[0]);
        }
    }
}

